/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.vespa.defaults.Defaults;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class LogReader {
    private final Path logDirectory;
    private final Pattern logFilePattern;

    LogReader(String logDirectory, String logFilePattern) {
        this(Paths.get(Defaults.getDefaults().underVespaHome(logDirectory), new String[0]), Pattern.compile(logFilePattern));
    }

    LogReader(Path logDirectory, Pattern logFilePattern) {
        this.logDirectory = logDirectory;
        this.logFilePattern = logFilePattern;
    }

    void writeLogs(OutputStream outputStream, Instant from, Instant to) {
        try {
            List<Path> logs = this.getMatchingFiles(from, to);
            for (int i = 0; i < logs.size(); ++i) {
                Path log = logs.get(i);
                boolean zipped = log.toString().endsWith(".gz");
                try (InputStream in = Files.newInputStream(log, new OpenOption[0]);){
                    InputStream inProxy;
                    if (i == 0 || i == logs.size() - 1) {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipped ? new GZIPInputStream(in) : in, StandardCharsets.UTF_8));
                             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zipped ? new GZIPOutputStream(buffer) : buffer, StandardCharsets.UTF_8));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                Instant at;
                                String[] parts = line.split("\t");
                                if (parts.length != 7 || !(at = Instant.EPOCH.plus((long)(Double.parseDouble(parts[0]) * 1000000.0), ChronoUnit.MICROS)).isAfter(from) || at.isAfter(to)) continue;
                                writer.write(line);
                                writer.newLine();
                            }
                        }
                        inProxy = new ByteArrayInputStream(buffer.toByteArray());
                    } else {
                        inProxy = in;
                    }
                    if (!zipped && !(outputStream instanceof GZIPOutputStream)) {
                        outputStream = new GZIPOutputStream(outputStream);
                    }
                    inProxy.transferTo(outputStream);
                    continue;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private List<Path> getMatchingFiles(Instant from, Instant to) {
        final HashMap paths = new HashMap();
        try {
            Files.walkFileTree(this.logDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (LogReader.this.logFilePattern.matcher(file.getFileName().toString()).matches()) {
                        paths.put(file, attrs.lastModifiedTime().toInstant());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ArrayList<Path> sorted = new ArrayList<Path>();
        Iterator entries = paths.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (((Instant)entry.getValue()).isAfter(from)) {
                sorted.add((Path)entry.getKey());
            }
            if (!((Instant)entry.getValue()).isAfter(to)) continue;
            break;
        }
        return sorted;
    }
}

