/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.VipStatusConfig;
import com.yahoo.container.handler.ClustersStatus;
import com.yahoo.container.jdisc.state.StateMonitor;

public class VipStatus {
    private final ClustersStatus clustersStatus;
    private final StateMonitor healthState;
    private Boolean rotationOverride = null;
    private boolean currentlyInRotation;
    private final Object mutex = new Object();

    public VipStatus() {
        this(new ClustersStatus());
    }

    public VipStatus(QrSearchersConfig dispatchers) {
        this(dispatchers, new ClustersStatus());
    }

    public VipStatus(ClustersStatus clustersStatus) {
        this(new QrSearchersConfig.Builder().build(), clustersStatus);
    }

    public VipStatus(QrSearchersConfig dispatchers, ClustersStatus clustersStatus) {
        this(dispatchers, clustersStatus, new StateMonitor());
    }

    @Inject
    public VipStatus(QrSearchersConfig dispatchers, ClustersStatus clustersStatus, StateMonitor healthState) {
        this.clustersStatus = clustersStatus;
        this.healthState = healthState;
        healthState.status(StateMonitor.Status.initializing);
        clustersStatus.setContainerHasClusters(!dispatchers.searchcluster().isEmpty());
        this.updateCurrentlyInRotation();
    }

    @Deprecated
    public VipStatus(QrSearchersConfig dispatchers, VipStatusConfig ignored, ClustersStatus clustersStatus) {
        this(dispatchers, clustersStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInRotation(Boolean inRotation) {
        Object object = this.mutex;
        synchronized (object) {
            this.rotationOverride = inRotation;
            this.updateCurrentlyInRotation();
        }
    }

    public void addToRotation(String clusterIdentifier) {
        this.clustersStatus.setUp(clusterIdentifier);
        this.updateCurrentlyInRotation();
    }

    public void removeFromRotation(String clusterIdentifier) {
        this.clustersStatus.setDown(clusterIdentifier);
        this.updateCurrentlyInRotation();
    }

    @Deprecated
    public void addToRotation(Object clusterIdentifier) {
        this.addToRotation((String)clusterIdentifier);
    }

    @Deprecated
    public void removeFromRotation(Object clusterIdentifier) {
        this.removeFromRotation((String)clusterIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentlyInRotation() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentlyInRotation = this.rotationOverride != null ? this.rotationOverride.booleanValue() : this.clustersStatus.containerShouldReceiveTraffic();
            if (this.currentlyInRotation) {
                this.healthState.status(StateMonitor.Status.up);
            } else if (this.healthState.status() == StateMonitor.Status.up) {
                this.healthState.status(StateMonitor.Status.down);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRotation() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentlyInRotation;
        }
    }
}

