/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.JSONObjectWithLegibleException;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.MetricsPacketsHandlerConfig;
import com.yahoo.container.jdisc.state.SnapshotProvider;
import com.yahoo.container.jdisc.state.StateHandler;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.metrics.MetricsPresentationConfig;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsPacketsHandler
extends AbstractRequestHandler {
    static final String APPLICATION_KEY = "application";
    static final String TIMESTAMP_KEY = "timestamp";
    static final String STATUS_CODE_KEY = "status_code";
    static final String STATUS_MSG_KEY = "status_msg";
    static final String METRICS_KEY = "metrics";
    static final String DIMENSIONS_KEY = "dimensions";
    static final String PACKET_SEPARATOR = "\n\n";
    private final StateMonitor monitor;
    private final Timer timer;
    private final SnapshotProvider snapshotPreprocessor;
    private final String applicationName;

    @Inject
    public MetricsPacketsHandler(StateMonitor monitor, Timer timer, ComponentRegistry<SnapshotProvider> preprocessors, MetricsPresentationConfig presentation, MetricsPacketsHandlerConfig config) {
        this.monitor = monitor;
        this.timer = timer;
        this.snapshotPreprocessor = StateHandler.getSnapshotPreprocessor(preprocessors, presentation);
        this.applicationName = config.application();
    }

    public ContentChannel handleRequest(final Request request, ResponseHandler handler) {
        new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", "application/json");
                return response;
            }

            protected Iterable<ByteBuffer> responseContent() {
                return Collections.singleton(ByteBuffer.wrap(MetricsPacketsHandler.this.buildMetricOutput(request.getUri().getQuery())));
            }
        }.dispatch(handler);
        return null;
    }

    private byte[] buildMetricOutput(String query) {
        try {
            if (query != null && query.equals("array-formatted")) {
                return this.getMetricsArray();
            }
            String output = this.jsonToString(this.getStatusPacket()) + this.getAllMetricsPackets() + "\n";
            return output.getBytes(StandardCharsets.UTF_8);
        }
        catch (JSONException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
    }

    private byte[] getMetricsArray() throws JSONException {
        JSONObject root = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)this.getStatusPacket());
        this.getPacketsForSnapshot(this.getSnapshot(), this.applicationName, this.timer.currentTimeMillis()).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        root.put(METRICS_KEY, (Object)jsonArray);
        return this.jsonToString(root).getBytes(StandardCharsets.UTF_8);
    }

    private JSONObject getStatusPacket() throws JSONException {
        JSONObjectWithLegibleException packet = new JSONObjectWithLegibleException();
        packet.put(APPLICATION_KEY, this.applicationName);
        StateMonitor.Status status = this.monitor.status();
        packet.put(STATUS_CODE_KEY, status.ordinal());
        packet.put(STATUS_MSG_KEY, status.name());
        return packet;
    }

    private String jsonToString(JSONObject jsonObject) throws JSONException {
        return jsonObject.toString(4);
    }

    private String getAllMetricsPackets() throws JSONException {
        StringBuilder ret = new StringBuilder();
        List<JSONObject> metricsPackets = this.getPacketsForSnapshot(this.getSnapshot(), this.applicationName, this.timer.currentTimeMillis());
        for (JSONObject packet : metricsPackets) {
            ret.append(PACKET_SEPARATOR);
            ret.append(this.jsonToString(packet));
        }
        return ret.toString();
    }

    private MetricSnapshot getSnapshot() {
        if (this.snapshotPreprocessor == null) {
            return this.monitor.snapshot();
        }
        return this.snapshotPreprocessor.latestSnapshot();
    }

    private List<JSONObject> getPacketsForSnapshot(MetricSnapshot metricSnapshot, String application, long timestamp) throws JSONException {
        if (metricSnapshot == null) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> packets = new ArrayList<JSONObject>();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : metricSnapshot) {
            MetricDimensions metricDimensions = snapshotEntry.getKey();
            MetricSet metricSet = snapshotEntry.getValue();
            JSONObjectWithLegibleException packet = new JSONObjectWithLegibleException();
            this.addMetaData(timestamp, application, packet);
            this.addDimensions(metricDimensions, packet);
            this.addMetrics(metricSet, packet);
            packets.add(packet);
        }
        return packets;
    }

    private void addMetaData(long timestamp, String application, JSONObjectWithLegibleException packet) {
        packet.put(APPLICATION_KEY, application);
        packet.put(TIMESTAMP_KEY, TimeUnit.MILLISECONDS.toSeconds(timestamp));
    }

    private void addDimensions(MetricDimensions metricDimensions, JSONObjectWithLegibleException packet) throws JSONException {
        Iterator dimensionsIterator = metricDimensions.iterator();
        if (dimensionsIterator.hasNext()) {
            JSONObjectWithLegibleException jsonDim = new JSONObjectWithLegibleException();
            packet.put(DIMENSIONS_KEY, (Object)jsonDim);
            for (Map.Entry dimensionEntry : metricDimensions) {
                jsonDim.put((String)dimensionEntry.getKey(), dimensionEntry.getValue());
            }
        }
    }

    private void addMetrics(MetricSet metricSet, JSONObjectWithLegibleException packet) throws JSONException {
        JSONObjectWithLegibleException metrics = new JSONObjectWithLegibleException();
        packet.put(METRICS_KEY, (Object)metrics);
        for (Map.Entry<String, MetricValue> metric : metricSet) {
            String name = metric.getKey();
            MetricValue value = metric.getValue();
            if (value instanceof CountMetric) {
                metrics.put(name + ".count", ((CountMetric)value).getCount());
                continue;
            }
            if (value instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)value;
                metrics.put(name + ".average", gauge.getAverage()).put(name + ".last", gauge.getLast()).put(name + ".max", gauge.getMax());
                if (!gauge.getPercentiles().isPresent()) continue;
                for (Tuple2<String, Double> prefixAndValue : gauge.getPercentiles().get()) {
                    metrics.put(name + "." + (String)prefixAndValue.first + "percentile", (Double)prefixAndValue.second);
                }
                continue;
            }
            throw new UnsupportedOperationException("Unknown metric class: " + value.getClass().getName());
        }
    }
}

