/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.yahoo.collections.PredicateSplit;
import com.yahoo.config.FileReference;
import com.yahoo.container.Container;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.osgi.Osgi;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class BundleLoader {
    private final List<Bundle> initialBundles;
    private final Map<FileReference, List<Bundle>> reference2Bundles = new LinkedHashMap<FileReference, List<Bundle>>();
    private final Logger log = Logger.getLogger(BundleLoader.class.getName());
    private final Osgi osgi;

    public BundleLoader(Osgi osgi) {
        this.osgi = osgi;
        this.initialBundles = Arrays.asList(osgi.getBundles());
    }

    private List<Bundle> obtainBundles(FileReference reference, FileAcquirer fileAcquirer) throws InterruptedException {
        File file = fileAcquirer.waitFor(reference, 7L, TimeUnit.DAYS);
        return this.osgi.install(file.getAbsolutePath());
    }

    private int install(List<FileReference> references) {
        HashSet<FileReference> bundlesToInstall = new HashSet<FileReference>(references);
        bundlesToInstall.removeAll(this.reference2Bundles.keySet());
        PredicateSplit bundlesToInstall_isDisk = PredicateSplit.partition(bundlesToInstall, BundleLoader::isDiskBundle);
        this.installBundlesFromDisk(bundlesToInstall_isDisk.trueValues);
        this.installBundlesFromFileDistribution(bundlesToInstall_isDisk.falseValues);
        this.startBundles();
        return bundlesToInstall.size();
    }

    private static boolean isDiskBundle(FileReference fileReference) {
        return fileReference.value().startsWith("file:");
    }

    private void installBundlesFromDisk(List<FileReference> bundlesToInstall) {
        for (FileReference reference : bundlesToInstall) {
            try {
                this.installBundleFromDisk(reference);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle '" + reference + "'", e);
            }
        }
    }

    private void installBundlesFromFileDistribution(List<FileReference> bundlesToInstall) {
        if (!bundlesToInstall.isEmpty()) {
            boolean hasFileDistribution;
            FileAcquirer fileAcquirer = Container.get().getFileAcquirer();
            boolean bl = hasFileDistribution = fileAcquirer != null;
            if (hasFileDistribution) {
                this.installWithFileDistribution(bundlesToInstall, fileAcquirer);
            } else {
                this.log.warning("Can't retrieve bundles since file distribution is disabled.");
            }
        }
    }

    private void installBundleFromDisk(FileReference reference) {
        assert (reference.value().startsWith("file:"));
        String referenceFileName = reference.value().substring("file:".length());
        this.log.info("Installing bundle from disk with reference '" + reference.value() + "'");
        File file = new File(referenceFileName);
        if (!file.exists()) {
            throw new IllegalArgumentException("Reference '" + reference.value() + "' not found on disk.");
        }
        List<Bundle> bundles = this.osgi.install(file.getAbsolutePath());
        this.reference2Bundles.put(reference, bundles);
    }

    private void installWithFileDistribution(List<FileReference> bundlesToInstall, FileAcquirer fileAcquirer) {
        for (FileReference reference : bundlesToInstall) {
            try {
                this.log.info("Installing bundle with reference '" + reference.value() + "'");
                List<Bundle> bundles = this.obtainBundles(reference, fileAcquirer);
                this.reference2Bundles.put(reference, bundles);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle '" + reference + "'", e);
            }
        }
    }

    private void startBundles() {
        for (List<Bundle> bundles : this.reference2Bundles.values()) {
            for (Bundle bundle : bundles) {
                try {
                    if (this.isFragment(bundle)) continue;
                    bundle.start();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not start bundle '" + bundle.getSymbolicName() + "'", e);
                }
            }
        }
    }

    private boolean isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision == null) {
            throw new NullPointerException("Null bundle revision means that bundle has probably been uninstalled: " + bundle.getSymbolicName() + ":" + bundle.getVersion());
        }
        return (bundleRevision.getTypes() & 1) != 0;
    }

    private int retainOnly(List<FileReference> newReferences) {
        HashSet<Bundle> bundlesToRemove = new HashSet<Bundle>(Arrays.asList(this.osgi.getBundles()));
        for (FileReference fileReferenceToKeep : newReferences) {
            if (!this.reference2Bundles.containsKey(fileReferenceToKeep)) continue;
            bundlesToRemove.removeAll((Collection)this.reference2Bundles.get(fileReferenceToKeep));
        }
        bundlesToRemove.removeAll(this.initialBundles);
        for (Bundle bundle : bundlesToRemove) {
            this.log.info("Removing bundle '" + bundle.toString() + "'");
            this.osgi.uninstall(bundle);
        }
        HashSet<FileReference> fileReferencesToRemove = new HashSet<FileReference>(this.reference2Bundles.keySet());
        fileReferencesToRemove.removeAll(newReferences);
        for (FileReference fileReferenceToRemove : fileReferencesToRemove) {
            this.reference2Bundles.remove(fileReferenceToRemove);
        }
        return bundlesToRemove.size();
    }

    public synchronized int use(List<FileReference> bundles) {
        int removedBundles = this.retainOnly(bundles);
        int installedBundles = this.install(bundles);
        this.startBundles();
        this.log.info(removedBundles + " bundles were removed, and " + installedBundles + " bundles were installed.");
        this.log.info(this.installedBundlesMessage());
        return removedBundles + installedBundles;
    }

    private String installedBundlesMessage() {
        StringBuilder sb = new StringBuilder("Installed bundles: {");
        for (Bundle b : this.osgi.getBundles()) {
            sb.append("[" + b.getBundleId() + "]" + b.getSymbolicName() + ", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }
}

