/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config.testutil;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.container.Container;
import com.yahoo.container.core.config.HandlersConfigurerDi;
import com.yahoo.container.di.CloudSubscriberFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.language.Linguistics;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.osgi.MockOsgi;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class HandlersConfigurerTestWrapper {
    private ConfigSourceSet configSources = new ConfigSourceSet(this.getClass().getSimpleName() + ": " + new Random().nextLong());
    private HandlersConfigurerDi configurer;
    private static final String[] testFiles = new String[]{"components.cfg", "handlers.cfg", "bundles.cfg", "string.cfg", "int.cfg", "renderers.cfg", "diagnostics.cfg", "qr-templates.cfg", "documentmanager.cfg", "schemamapping.cfg", "chains.cfg", "container-mbus.cfg", "container-mbus.cfg", "specialtokens.cfg", "documentdb-info.cfg", "qr-search.cfg", "query-profiles.cfg"};
    private final Set<File> createdFiles = new LinkedHashSet<File>();
    private int lastGeneration = 0;
    private final Container container;

    private void createFiles(String configId) {
        if (configId.startsWith("dir:")) {
            try {
                System.setProperty("config.id", configId);
                String dirName = configId.substring(4);
                for (String file : testFiles) {
                    this.createIfNotExists(dirName, file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void createIfNotExists(String dir, String file) throws IOException {
        File f = new File(dir + "/" + file);
        if (f.createNewFile()) {
            this.createdFiles.add(f);
        }
    }

    public HandlersConfigurerTestWrapper(String configId) {
        this(Container.get(), configId);
    }

    public HandlersConfigurerTestWrapper(Container container, String configId) {
        this.createFiles(configId);
        MockOsgi mockOsgi = new MockOsgi();
        container.setOsgi(mockOsgi);
        ComponentDeconstructor testDeconstructor = this.getTestDeconstructor();
        this.configurer = new HandlersConfigurerDi((SubscriberFactory)new CloudSubscriberFactory((ConfigSource)this.configSources), container, configId, testDeconstructor, HandlersConfigurerTestWrapper.guiceInjector(), (OsgiFramework)mockOsgi);
        this.container = container;
    }

    private ComponentDeconstructor getTestDeconstructor() {
        return new ComponentDeconstructor(){

            public void deconstruct(Object component) {
                AbstractComponent abstractComponent;
                if (component instanceof AbstractComponent && (abstractComponent = (AbstractComponent)component).isDeconstructable()) {
                    ((AbstractComponent)component).deconstruct();
                }
            }
        };
    }

    public void reloadConfig() {
        this.configurer.reloadConfig(++this.lastGeneration);
        this.configurer.getNewComponentGraph(HandlersConfigurerTestWrapper.guiceInjector(), false);
    }

    public void shutdown() {
        for (File f : this.createdFiles) {
            f.delete();
        }
    }

    public ComponentRegistry<RequestHandler> getRequestHandlerRegistry() {
        return this.container.getRequestHandlerRegistry();
    }

    private static Injector guiceInjector() {
        return Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Linguistics.class).to(SimpleLinguistics.class).in(Scopes.SINGLETON);
            }
        }});
    }
}

