/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONException;
import org.json.JSONObject;

public class LogReader {
    long earliestLogThreshold;
    long latestLogThreshold;

    protected JSONObject readLogs(String logDirectory, long earliestLogThreshold, long latestLogThreshold) throws IOException, JSONException {
        this.earliestLogThreshold = earliestLogThreshold;
        this.latestLogThreshold = latestLogThreshold;
        JSONObject json = new JSONObject();
        File root = new File(logDirectory);
        this.traverse_folder(root, json, "");
        return json;
    }

    private void traverse_folder(File root, JSONObject json, String filename) throws IOException, JSONException {
        File[] files;
        for (File child : files = root.listFiles()) {
            long logTime = Files.readAttributes(child.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
            if (child.isFile() && this.earliestLogThreshold < logTime && logTime < this.latestLogThreshold) {
                json.put(filename + child.getName(), (Object)DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(child.toPath())));
                continue;
            }
            if (child.isFile()) continue;
            this.traverse_folder(child, json, filename + child.getName() + "-");
        }
    }
}

