/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONException;
import org.json.JSONObject;

public class LogReader {
    long earliestLogThreshold;
    long latestLogThreshold;

    public LogReader(long earliestLogThreshold, long latestLogThreshold) {
        this.earliestLogThreshold = earliestLogThreshold;
        this.latestLogThreshold = latestLogThreshold;
    }

    protected JSONObject readLogs(String logDirectory) throws IOException, JSONException {
        JSONObject json = new JSONObject();
        File root = new File(logDirectory);
        this.traverse_folder(root, json, "");
        return json;
    }

    private void traverse_folder(File root, JSONObject json, String filename) throws IOException, JSONException {
        File[] files;
        File[] fileArray = files = root.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File child;
            File temp = child = fileArray[i];
            JSONObject childJson = new JSONObject();
            long logTime = child.lastModified();
            if (child.isFile() && this.earliestLogThreshold < logTime && logTime < this.latestLogThreshold) {
                json.put(filename + child.getName(), (Object)DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(child.toPath())));
                continue;
            }
            if (child.isFile()) continue;
            this.traverse_folder(child, json, filename + child.getName() + "-");
        }
    }
}

