/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class QrLoggingConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "7675f2fe68a77c6f59ef345903728e9c";
    public static final String CONFIG_DEF_NAME = "qr-logging";
    public static final String CONFIG_DEF_NAMESPACE = "container.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.core", "logger string default=\"com.yahoo\"", "speciallog[].name string", "speciallog[].type string", "speciallog[].filehandler.name string default=\"\"", "speciallog[].filehandler.pattern string default=\".%Y%m%d%H%M%S\"", "speciallog[].filehandler.rotation string default=\"0 60 ...\"", "speciallog[].filehandler.rotatescheme string default=\"date\"", "speciallog[].filehandler.symlink string default=\"\"", "speciallog[].cachehandler.name string default=\"\"", "speciallog[].cachehandler.size int default=1000"};
    private final StringNode logger;
    private final InnerNodeVector<Speciallog> speciallog;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public QrLoggingConfig(Builder builder) {
        this(builder, true);
    }

    private QrLoggingConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr-logging must be initialized: " + builder.__uninitialized);
        }
        this.logger = builder.logger == null ? new StringNode("com.yahoo") : new StringNode(builder.logger);
        this.speciallog = Speciallog.createVector(builder.speciallog);
    }

    public String logger() {
        return this.logger.value();
    }

    public List<Speciallog> speciallog() {
        return this.speciallog;
    }

    public Speciallog speciallog(int i) {
        return (Speciallog)((Object)this.speciallog.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrLoggingConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Speciallog
    extends InnerNode {
        private final StringNode name;
        private final StringNode type;
        private final Filehandler filehandler;
        private final Cachehandler cachehandler;

        public Speciallog(Builder builder) {
            this(builder, true);
        }

        private Speciallog(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr-logging.speciallog[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
            this.filehandler = new Filehandler(builder.filehandler, throwIfUninitialized);
            this.cachehandler = new Cachehandler(builder.cachehandler, throwIfUninitialized);
        }

        public String name() {
            return this.name.value();
        }

        public String type() {
            return this.type.value();
        }

        public Filehandler filehandler() {
            return this.filehandler;
        }

        public Cachehandler cachehandler() {
            return this.cachehandler;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Speciallog newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("speciallog");
            return changes;
        }

        private static InnerNodeVector<Speciallog> createVector(List<Builder> builders) {
            ArrayList<Speciallog> elems = new ArrayList<Speciallog>();
            for (Builder b : builders) {
                elems.add(new Speciallog(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Cachehandler
        extends InnerNode {
            private final StringNode name;
            private final IntegerNode size;

            public Cachehandler(Builder builder) {
                this(builder, true);
            }

            private Cachehandler(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-logging.speciallog[].cachehandler must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode(QrLoggingConfig.CONFIG_DEF_VERSION) : new StringNode(builder.name);
                this.size = builder.size == null ? new IntegerNode(1000) : new IntegerNode(builder.size.intValue());
            }

            public String name() {
                return this.name.value();
            }

            public int size() {
                return this.size.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Cachehandler newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("cachehandler");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String name = null;
                private Integer size = null;

                public Builder() {
                }

                public Builder(Cachehandler config) {
                    this.name(config.name());
                    this.size(config.size());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.size != null) {
                        this.size(__superior.size);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    return this;
                }

                public Builder size(int __value) {
                    this.size = __value;
                    return this;
                }

                private Builder size(String __value) {
                    return this.size(Integer.valueOf(__value));
                }
            }
        }

        public static final class Filehandler
        extends InnerNode {
            private final StringNode name;
            private final StringNode pattern;
            private final StringNode rotation;
            private final StringNode rotatescheme;
            private final StringNode symlink;

            public Filehandler(Builder builder) {
                this(builder, true);
            }

            private Filehandler(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for qr-logging.speciallog[].filehandler must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode(QrLoggingConfig.CONFIG_DEF_VERSION) : new StringNode(builder.name);
                this.pattern = builder.pattern == null ? new StringNode(".%Y%m%d%H%M%S") : new StringNode(builder.pattern);
                this.rotation = builder.rotation == null ? new StringNode("0 60 ...") : new StringNode(builder.rotation);
                this.rotatescheme = builder.rotatescheme == null ? new StringNode("date") : new StringNode(builder.rotatescheme);
                this.symlink = builder.symlink == null ? new StringNode(QrLoggingConfig.CONFIG_DEF_VERSION) : new StringNode(builder.symlink);
            }

            public String name() {
                return this.name.value();
            }

            public String pattern() {
                return this.pattern.value();
            }

            public String rotation() {
                return this.rotation.value();
            }

            public String rotatescheme() {
                return this.rotatescheme.value();
            }

            public String symlink() {
                return this.symlink.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Filehandler newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("filehandler");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String name = null;
                private String pattern = null;
                private String rotation = null;
                private String rotatescheme = null;
                private String symlink = null;

                public Builder() {
                }

                public Builder(Filehandler config) {
                    this.name(config.name());
                    this.pattern(config.pattern());
                    this.rotation(config.rotation());
                    this.rotatescheme(config.rotatescheme());
                    this.symlink(config.symlink());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.pattern != null) {
                        this.pattern(__superior.pattern);
                    }
                    if (__superior.rotation != null) {
                        this.rotation(__superior.rotation);
                    }
                    if (__superior.rotatescheme != null) {
                        this.rotatescheme(__superior.rotatescheme);
                    }
                    if (__superior.symlink != null) {
                        this.symlink(__superior.symlink);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    return this;
                }

                public Builder pattern(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.pattern = __value;
                    return this;
                }

                public Builder rotation(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.rotation = __value;
                    return this;
                }

                public Builder rotatescheme(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.rotatescheme = __value;
                    return this;
                }

                public Builder symlink(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.symlink = __value;
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "type"));
            private String name = null;
            private String type = null;
            public Filehandler.Builder filehandler = new Filehandler.Builder();
            public Cachehandler.Builder cachehandler = new Cachehandler.Builder();

            public Builder() {
            }

            public Builder(Speciallog config) {
                this.name(config.name());
                this.type(config.type());
                this.filehandler(new Filehandler.Builder(config.filehandler()));
                this.cachehandler(new Cachehandler.Builder(config.cachehandler()));
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                this.filehandler(this.filehandler.override(__superior.filehandler));
                this.cachehandler(this.cachehandler.override(__superior.cachehandler));
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder type(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                this.__uninitialized.remove("type");
                return this;
            }

            public Builder filehandler(Filehandler.Builder __builder) {
                this.filehandler = __builder;
                return this;
            }

            public Builder cachehandler(Cachehandler.Builder __builder) {
                this.cachehandler = __builder;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String logger = null;
        public List<Speciallog.Builder> speciallog = new ArrayList<Speciallog.Builder>();

        public Builder() {
        }

        public Builder(QrLoggingConfig config) {
            this.logger(config.logger());
            for (Speciallog s : config.speciallog()) {
                this.speciallog(new Speciallog.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.logger != null) {
                this.logger(__superior.logger);
            }
            if (!__superior.speciallog.isEmpty()) {
                this.speciallog.addAll(__superior.speciallog);
            }
            return this;
        }

        public Builder logger(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.logger = __value;
            return this;
        }

        public Builder speciallog(Speciallog.Builder __builder) {
            this.speciallog.add(__builder);
            return this;
        }

        public Builder speciallog(List<Speciallog.Builder> __builders) {
            this.speciallog = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrLoggingConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrLoggingConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrLoggingConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

