/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.rendering;

import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.handler.ResponseHeaders;
import com.yahoo.processing.handler.ResponseStatus;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.text.JSONWriter;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IdentityHashMap;
import java.util.Map;

public class ProcessingRenderer
extends AsynchronousSectionedRenderer<Response> {
    private Map<Request, Request> renderedRequests = new IdentityHashMap<Request, Request>();
    private JSONWriter jsonWriter;
    private int level;

    @Override
    public void init() {
        super.init();
        this.level = 0;
    }

    @Override
    public final void beginResponse(OutputStream stream) throws IOException {
        this.jsonWriter = new JSONWriter(stream);
    }

    @Override
    public final void endResponse() throws IOException {
    }

    @Override
    public final void beginList(DataList<?> list) throws IOException {
        if (this.level > 0) {
            this.jsonWriter.beginArrayValue();
        }
        this.jsonWriter.beginObject();
        if (this.level == 0) {
            this.renderTrace();
        }
        if (!list.request().errors().isEmpty() && !this.rendered(list.request())) {
            this.jsonWriter.beginField("errors");
            this.jsonWriter.beginArray();
            for (ErrorMessage error : list.request().errors()) {
                if (this.renderedRequests == null) {
                    this.renderedRequests = new IdentityHashMap<Request, Request>();
                }
                this.renderedRequests.put(list.request(), list.request());
                this.jsonWriter.beginArrayValue();
                if (error.getCause() != null) {
                    this.jsonWriter.beginObject();
                    this.jsonWriter.beginField("error").value(error.toString()).endField();
                    this.jsonWriter.beginField("stacktrace").value(this.stackTraceAsString(error.getCause())).endField();
                    this.jsonWriter.endObject();
                } else {
                    this.jsonWriter.value(error.toString());
                }
                this.jsonWriter.endArrayValue();
            }
            this.jsonWriter.endArray();
            this.jsonWriter.endField();
        }
        this.jsonWriter.beginField("datalist");
        this.jsonWriter.beginArray();
        ++this.level;
    }

    private String stackTraceAsString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private boolean rendered(Request request) {
        return this.renderedRequests != null && this.renderedRequests.containsKey(request);
    }

    @Override
    public final void endList(DataList<?> list) throws IOException {
        this.jsonWriter.endArray();
        this.jsonWriter.endField();
        this.jsonWriter.endObject();
        if (this.level > 0) {
            this.jsonWriter.endArrayValue();
        }
        --this.level;
    }

    @Override
    public final void data(Data data) throws IOException {
        if (!this.shouldRender(data)) {
            return;
        }
        this.jsonWriter.beginArrayValue();
        this.jsonWriter.beginObject();
        this.jsonWriter.beginField("data");
        this.renderValue(data, this.jsonWriter);
        this.jsonWriter.endField();
        this.jsonWriter.endObject();
        this.jsonWriter.endArrayValue();
    }

    protected void renderValue(Data data, JSONWriter writer) throws IOException {
        writer.value(data.toString());
    }

    protected boolean shouldRender(Data data) {
        if (data instanceof ResponseHeaders) {
            return false;
        }
        return !(data instanceof ResponseStatus);
    }

    @Override
    public final String getEncoding() {
        return null;
    }

    @Override
    public final String getMimeType() {
        return "application/json";
    }

    private boolean renderTrace() throws IOException {
        if (this.getExecution().trace().getTraceLevel() == 0) {
            return false;
        }
        this.jsonWriter.beginField("trace");
        try {
            this.getExecution().trace().traceNode().accept((TraceVisitor)new TraceRenderingVisitor(this.jsonWriter));
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
        this.jsonWriter.endField();
        return true;
    }

    private static class WrappedIOException
    extends RuntimeException {
        private WrappedIOException(IOException cause) {
            super(cause);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }

    private static class TraceRenderingVisitor
    extends TraceVisitor {
        private JSONWriter jsonWriter;

        public TraceRenderingVisitor(JSONWriter jsonWriter) {
            this.jsonWriter = jsonWriter;
        }

        public void entering(TraceNode node) {
            try {
                this.jsonWriter.beginArray();
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }

        public void leaving(TraceNode node) {
            try {
                this.jsonWriter.endArray();
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }

        public void visit(TraceNode node) {
            if (!(node.payload() instanceof String)) {
                return;
            }
            try {
                this.jsonWriter.beginArrayValue();
                if (node.timestamp() != 0L) {
                    this.jsonWriter.beginObject();
                    this.jsonWriter.beginField("timestamp").value((Number)node.timestamp()).endField();
                    this.jsonWriter.beginField("message").value(node.payload().toString()).endField();
                    this.jsonWriter.endObject();
                } else {
                    this.jsonWriter.value(node.payload().toString());
                }
                this.jsonWriter.endArrayValue();
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }
    }
}

