/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.StateMetricConsumer;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.application.MetricConsumer;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class StateMonitor
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(StateMonitor.class.getName());
    private final CopyOnWriteArrayList<StateMetricConsumer> consumers = new CopyOnWriteArrayList();
    private final Thread thread;
    private final Timer timer;
    private final long snapshotIntervalMs;
    private long lastSnapshotTimeMs;
    private volatile MetricSnapshot snapshot;
    private final TreeSet<String> valueNames = new TreeSet();

    @Inject
    public StateMonitor(HealthMonitorConfig config, Timer timer) {
        this.timer = timer;
        this.snapshotIntervalMs = (long)(config.snapshot_interval() * (double)TimeUnit.SECONDS.toMillis(1L));
        this.lastSnapshotTimeMs = timer.currentTimeMillis();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                StateMonitor.this.run();
            }
        }, "StateMonitor");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public MetricConsumer newMetricConsumer() {
        StateMetricConsumer consumer = new StateMetricConsumer();
        this.consumers.add(consumer);
        return consumer;
    }

    public MetricSnapshot snapshot() {
        return this.snapshot;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMs;
    }

    boolean checkTime() {
        long now = this.timer.currentTimeMillis();
        if (now < this.lastSnapshotTimeMs + this.snapshotIntervalMs) {
            return false;
        }
        this.snapshot = this.createSnapshot(this.lastSnapshotTimeMs, now);
        this.lastSnapshotTimeMs = now;
        return true;
    }

    private void run() {
        log.finest("StateMonitor started.");
        try {
            while (!Thread.interrupted()) {
                this.checkTime();
                Thread.sleep(this.lastSnapshotTimeMs + this.snapshotIntervalMs - this.timer.currentTimeMillis());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.finest("StateMonitor stopped.");
    }

    private MetricSnapshot createSnapshot(long fromMillis, long toMillis) {
        MetricSnapshot snapshot = new MetricSnapshot(fromMillis, toMillis, TimeUnit.MILLISECONDS);
        for (StateMetricConsumer consumer : this.consumers) {
            snapshot.add(consumer.createSnapshot());
        }
        this.updateNames(snapshot);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNames(MetricSnapshot current) {
        TreeSet<String> seen = new TreeSet<String>();
        for (Map.Entry<MetricDimensions, MetricSet> dimensionAndMetric : current) {
            for (Map.Entry<String, MetricValue> nameAndMetric : dimensionAndMetric.getValue()) {
                seen.add(nameAndMetric.getKey());
            }
        }
        TreeSet<String> treeSet = this.valueNames;
        synchronized (treeSet) {
            for (String name : this.valueNames) {
                if (seen.contains(name)) continue;
                current.add((MetricDimensions)StateMetricConsumer.NULL_CONTEXT, name, 0);
            }
            this.valueNames.addAll(seen);
        }
    }

    public void deconstruct() {
        this.thread.interrupt();
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.thread.isAlive()) {
            log.warning("StateMonitor failed to terminate within 5 seconds of interrupt signal. Ignoring.");
        }
    }
}

