/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.common.annotations.Beta;
import com.google.inject.Module;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ReadableContentChannel;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.jdisc.test.TestDriver;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Beta
public class RequestHandlerTestDriver
implements AutoCloseable {
    private TestDriver driver = TestDriver.newSimpleApplicationInstanceWithoutOsgi((Module[])new Module[0]);
    private MockResponseHandler responseHandler = null;

    public RequestHandlerTestDriver(RequestHandler handler) {
        this("http://localhost/*", handler);
    }

    public RequestHandlerTestDriver(String binding, RequestHandler handler) {
        ContainerBuilder builder = this.driver.newContainerBuilder();
        builder.serverBindings().bind(binding, (Object)handler);
        this.driver.activateContainer(builder);
    }

    @Override
    public void close() {
        if (this.responseHandler != null) {
            this.responseHandler.readAll();
        }
        RequestHandlerTestDriver.assertTrue("Driver closed", this.driver.close());
    }

    public TestDriver jDiscDriver() {
        return this.driver;
    }

    public MockResponseHandler sendRequest(String uri) {
        return this.sendRequest(uri, HttpRequest.Method.GET);
    }

    public MockResponseHandler sendRequest(String uri, HttpRequest.Method method) {
        return this.sendRequest(uri, method, "");
    }

    public MockResponseHandler sendRequest(String uri, HttpRequest.Method method, String body) {
        return this.sendRequest(uri, method, ByteBuffer.wrap(body.getBytes(StandardCharsets.UTF_8)));
    }

    public MockResponseHandler sendRequest(String uri, HttpRequest.Method method, ByteBuffer body) {
        this.responseHandler = new MockResponseHandler();
        HttpRequest request = HttpRequest.newServerRequest((CurrentContainer)this.driver, (URI)URI.create(uri), (HttpRequest.Method)method);
        request.context().put("contextVariable", 37);
        ContentChannel requestContent = request.connect((ResponseHandler)this.responseHandler);
        requestContent.write(body, null);
        requestContent.close(null);
        request.release();
        return this.responseHandler;
    }

    public String censorDigits(String s) {
        return s.replaceAll("[0-9]", "d");
    }

    private static void assertTrue(String assertionMessage, boolean expectedTrue) {
        if (!expectedTrue) {
            throw new RuntimeException("Assertion in ProcessingTestDriver failed: " + assertionMessage);
        }
    }

    public static class MockResponseHandler
    implements ResponseHandler {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final ReadableContentChannel content = new ReadableContentChannel();
        private final BufferedContentChannel buffer = new BufferedContentChannel();
        Response response = null;

        public MockResponseHandler awaitResponse() throws InterruptedException {
            RequestHandlerTestDriver.assertTrue("Handler responded", this.latch.await(60L, TimeUnit.SECONDS));
            return this;
        }

        public String read() {
            ByteBuffer nextBuffer = this.content.read();
            if (nextBuffer == null) {
                return null;
            }
            return Charset.forName("utf-8").decode(nextBuffer).toString();
        }

        public int available() {
            return this.content.available();
        }

        public String readAll() {
            String next;
            StringBuilder responseString = new StringBuilder();
            while (null != (next = this.read())) {
                responseString.append(next);
            }
            return responseString.toString();
        }

        public String readIfAvailable() {
            StringBuilder b = new StringBuilder();
            while (this.content.available() > 0) {
                ByteBuffer nextBuffer = this.content.read();
                b.append(Charset.forName("utf-8").decode(nextBuffer).toString());
            }
            return b.toString();
        }

        public ContentChannel handleResponse(Response response) {
            this.response = response;
            this.latch.countDown();
            this.buffer.connectTo((ContentChannel)this.content);
            return this.buffer;
        }

        public void clientClose() {
            this.buffer.close(null);
        }

        public int getStatus() {
            return this.response.getStatus();
        }

        public Response getResponse() {
            return this.response;
        }
    }
}

