/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.osgi;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Version;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.osgi.Osgi;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class OsgiImpl
implements Osgi {
    private static final Logger log = Logger.getLogger(OsgiImpl.class.getName());
    private final OsgiFramework jdiscOsgi;

    public OsgiImpl(OsgiFramework jdiscOsgi) {
        this.jdiscOsgi = jdiscOsgi;
    }

    @Override
    public Bundle[] getBundles() {
        List bundles = this.jdiscOsgi.bundles();
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public Class<Object> resolveClass(BundleInstantiationSpecification spec) {
        Bundle bundle = this.getBundle(spec.bundle);
        if (bundle != null) {
            return OsgiImpl.resolveFromBundle(spec, bundle);
        }
        return OsgiImpl.resolveFromClassPath(spec);
    }

    private static Class<Object> resolveFromClassPath(BundleInstantiationSpecification spec) {
        try {
            return Class.forName(spec.classId.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not create a component with id '" + spec.classId.getName() + "'. Tried to load class directly, since no bundle was found for spec: " + spec.bundle + ". If a bundle with the same name is installed, there is a either a version mismatch or the installed bundle's version contains a qualifier string.");
        }
    }

    private static Class<Object> resolveFromBundle(BundleInstantiationSpecification spec, Bundle bundle) {
        try {
            OsgiImpl.ensureBundleActive(bundle);
            return bundle.loadClass(spec.classId.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + spec.classId.getName() + "' from bundle " + bundle, e);
        }
    }

    private static void ensureBundleActive(Bundle bundle) throws IllegalStateException {
        int state = bundle.getState();
        BundleException cause = null;
        if (state != 32) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                cause = e;
            }
            throw new IllegalStateException("Bundle " + bundle + " is not active. State=" + state + ".", cause);
        }
    }

    @Override
    public Bundle getBundle(ComponentSpecification id) {
        Bundle highestMatch = null;
        for (Bundle bundle : this.getBundles()) {
            assert (bundle.getSymbolicName() != null) : "ensureHasBundleSymbolicName not called during installation";
            if (!bundle.getSymbolicName().equals(id.getName()) || !id.getVersionSpecification().matches(OsgiImpl.versionOf(bundle)) || highestMatch != null && OsgiImpl.versionOf(highestMatch).compareTo(OsgiImpl.versionOf(bundle)) >= 0) continue;
            highestMatch = bundle;
        }
        return highestMatch;
    }

    private static Version versionOf(Bundle bundle) {
        Object bundleVersion = bundle.getHeaders().get("Bundle-Version");
        if (bundleVersion == null) {
            return Version.emptyVersion;
        }
        return new Version(bundleVersion.toString());
    }

    @Override
    public List<Bundle> install(String absolutePath) {
        try {
            return this.jdiscOsgi.installBundle(OsgiImpl.normalizeLocation(absolutePath));
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    private static String normalizeLocation(String location) {
        if (location.indexOf(58) < 0) {
            location = "file:" + location;
        }
        return location;
    }

    @Override
    public void uninstall(Bundle bundle) {
        try {
            bundle.uninstall();
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void refreshPackages() {
        this.jdiscOsgi.refreshPackages();
    }
}

