/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.rendering;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.log.LogLevel;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.rendering.AsynchronousRenderer;
import com.yahoo.processing.response.AbstractDataList;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.processing.response.Ordered;
import com.yahoo.processing.response.Streamed;
import com.yahoo.protect.Process;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AsynchronousSectionedRenderer<RESPONSE extends Response>
extends AsynchronousRenderer<RESPONSE> {
    private static final Logger logger = Logger.getLogger(AsynchronousSectionedRenderer.class.getName());
    private Deque<DataListListener> dataListListenerStack;
    private boolean beforeHandoverMode;
    private OutputStream stream;
    private RESPONSE response;
    private Execution execution;
    private boolean clientClosed;
    private Object singleThreaded;
    private final Executor renderingExecutor;
    private final boolean renderingExecutorIsOwned;
    private SettableFuture<Boolean> success;
    private ContentChannel channel;
    private CompletionHandler completionHandler;
    private boolean networkIsInitialized;
    private boolean isInitialized = false;

    public abstract void beginResponse(OutputStream var1) throws IOException;

    public abstract void beginList(DataList<?> var1) throws IOException;

    public abstract void data(Data var1) throws IOException;

    public abstract void endList(DataList<?> var1) throws IOException;

    public abstract void endResponse() throws IOException;

    private static ThreadPoolExecutor createExecutor() {
        int threadCount = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactoryFactory.getThreadFactory((String)"rendering"));
        executor.prestartAllCoreThreads();
        return executor;
    }

    public AsynchronousSectionedRenderer() {
        this(null);
    }

    public AsynchronousSectionedRenderer(Executor executor) {
        if (executor == null) {
            this.renderingExecutor = AsynchronousSectionedRenderer.createExecutor();
            this.renderingExecutorIsOwned = true;
        } else {
            this.renderingExecutor = executor;
            this.renderingExecutorIsOwned = false;
        }
    }

    @Override
    public final ListenableFuture<Boolean> render(OutputStream stream, RESPONSE response, Execution execution, Request request) {
        if (this.beforeHandoverMode) {
            this.beforeHandoverMode = false;
            if (!this.dataListListenerStack.isEmpty() && this.dataListListenerStack.getFirst().list.incoming().isComplete()) {
                this.getExecutor().execute(this.dataListListenerStack.getFirst());
            }
            return this.success;
        }
        return this.startRender(stream, response, execution, request);
    }

    public void deconstruct() {
        super.deconstruct();
        if (this.renderingExecutorIsOwned && this.renderingExecutor instanceof ThreadPoolExecutor) {
            this.shutdown((ThreadPoolExecutor)this.renderingExecutor);
        }
    }

    private void shutdown(ThreadPoolExecutor executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Rendering thread pool did not shutdown in 30 seconds");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final ListenableFuture<Boolean> renderBeforeHandover(OutputStream stream, RESPONSE response, Execution execution, Request request) {
        this.beforeHandoverMode = true;
        if (!this.isInitialized) {
            throw new IllegalStateException("render() invoked before init().");
        }
        return this.startRender(stream, response, execution, request);
    }

    private ListenableFuture<Boolean> startRender(OutputStream stream, RESPONSE response, Execution execution, Request request) {
        this.response = response;
        this.stream = stream;
        this.execution = execution;
        DataListListener parentOfTopLevelListener = new DataListListener((DataList)new ParentOfTopLevel(request, response.data()), null);
        this.dataListListenerStack.addFirst(parentOfTopLevelListener);
        this.success = SettableFuture.create();
        try {
            this.getExecutor().execute(parentOfTopLevelListener);
        }
        catch (RejectedExecutionException e) {
            parentOfTopLevelListener.closeIO(e);
        }
        return this.success;
    }

    Executor getExecutor() {
        return this.beforeHandoverMode ? MoreExecutors.directExecutor() : this.renderingExecutor;
    }

    Executor getRenderingExecutor() {
        return this.renderingExecutor;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public Response getResponse() {
        return this.response;
    }

    protected boolean clientClosed() {
        return this.clientClosed;
    }

    protected void onClientClosed() {
    }

    public int getRecursionLevel() {
        return this.dataListListenerStack.size() - 1;
    }

    @Override
    public final void setNetworkWiring(ContentChannel channel, CompletionHandler completionHandler) {
        if (this.networkIsInitialized) {
            throw new IllegalStateException("Network wiring already set and can only be set once.");
        }
        this.channel = channel;
        this.completionHandler = completionHandler;
        this.networkIsInitialized = true;
    }

    @Override
    public void init() {
        this.beforeHandoverMode = false;
        this.clientClosed = false;
        this.singleThreaded = new Object();
        this.dataListListenerStack = new ArrayDeque<DataListListener>();
        this.networkIsInitialized = false;
        this.isInitialized = true;
    }

    private static class ParentOfTopLevel
    extends AbstractDataList {
        private DataList trueTopLevel;

        public ParentOfTopLevel(Request request, DataList trueTopLevel) {
            super(request);
            this.trueTopLevel = trueTopLevel;
            this.freeze();
        }

        public Data add(Data data) {
            throw new IllegalStateException("We're not supposed to add to this");
        }

        public void addDataListener(Runnable listener) {
            throw new IllegalStateException("We're not supposed to listen to or add to this");
        }

        public Data get(int index) {
            if (index > 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.trueTopLevel;
        }

        public List<Data> asList() {
            return Collections.singletonList(this.trueTopLevel);
        }

        public String toString() {
            return "ParentOfTopLevel";
        }
    }

    private abstract class RendererListener
    implements Runnable {
        private RendererListener() {
        }

        protected abstract void render() throws IOException, InterruptedException, ExecutionException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = AsynchronousSectionedRenderer.this.singleThreaded;
                synchronized (object) {
                    try {
                        this.render();
                    }
                    catch (Exception e) {
                        Level level = LogLevel.WARNING;
                        if (e instanceof IOException) {
                            level = LogLevel.DEBUG;
                            if (!AsynchronousSectionedRenderer.this.clientClosed) {
                                AsynchronousSectionedRenderer.this.clientClosed = true;
                                AsynchronousSectionedRenderer.this.onClientClosed();
                            }
                        }
                        if (logger.isLoggable(level)) {
                            logger.log(level, "Exception caught during response rendering.", e);
                        }
                        if (AsynchronousSectionedRenderer.this.channel != null) {
                            try {
                                AsynchronousSectionedRenderer.this.channel.close(AsynchronousSectionedRenderer.this.completionHandler);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        AsynchronousSectionedRenderer.this.success.setException((Throwable)e);
                    }
                }
            }
            catch (Error e) {
                Process.logAndDie((String)"Caught fatal error during rendering.", (Throwable)e);
            }
        }

        protected void flushIfLikelyToSuspend(DataList list) throws IOException {
            if (!list.incoming().isComplete()) {
                AsynchronousSectionedRenderer.this.stream.flush();
            }
        }
    }

    private class DataListener
    extends RendererListener {
        private DataListListener dataListListener;

        public DataListener(DataListListener dataListListener) {
            this.dataListListener = dataListListener;
        }

        @Override
        protected void render() throws IOException, InterruptedException, ExecutionException {
            this.dataListListener.renderData();
            this.flushIfLikelyToSuspend(this.dataListListener.list);
        }
    }

    private class DataListListener
    extends RendererListener {
        private int currentIndex = 0;
        private int uncompletedChildren = 0;
        private boolean listStartIsRendered = false;
        private final DataList list;
        private final DataListListener parent;

        public DataListListener(DataList list, DataListListener parent) {
            this.list = list;
            this.parent = parent;
        }

        @Override
        protected void render() throws IOException, InterruptedException, ExecutionException {
            boolean startedRendering;
            if (AsynchronousSectionedRenderer.this.dataListListenerStack.peekFirst() != this) {
                return;
            }
            if (AsynchronousSectionedRenderer.this.beforeHandoverMode && !this.list.isFrozen()) {
                return;
            }
            if (!AsynchronousSectionedRenderer.this.beforeHandoverMode) {
                this.list.complete().get();
            }
            if (!(startedRendering = this.renderData()) || this.uncompletedChildren > 0) {
                return;
            }
            if (this.list.complete().isDone()) {
                this.endListLevel();
            } else {
                AsynchronousSectionedRenderer.this.stream.flush();
            }
        }

        private void endListLevel() throws IOException {
            this.endRenderLevel(this.list);
            AsynchronousSectionedRenderer.this.stream.flush();
            AsynchronousSectionedRenderer.this.dataListListenerStack.removeFirst();
            if (this.parent != null) {
                this.parent.childCompleted();
            }
        }

        private void childCompleted() {
            --this.uncompletedChildren;
            if (this.uncompletedChildren > 0) {
                return;
            }
            if (this.list.incoming().isComplete()) {
                this.run();
            }
        }

        private boolean renderData() throws IOException {
            if (AsynchronousSectionedRenderer.this.dataListListenerStack.peekFirst() != this) {
                return false;
            }
            this.renderDataListStart();
            for (Object data : this.list.incoming().drain()) {
                this.list.add((Data)data);
            }
            this.renderDataList(this.list);
            return true;
        }

        void renderDataListStart() throws IOException {
            if (!this.listStartIsRendered) {
                if (this.list instanceof ParentOfTopLevel) {
                    AsynchronousSectionedRenderer.this.beginResponse(AsynchronousSectionedRenderer.this.stream);
                } else {
                    AsynchronousSectionedRenderer.this.beginList(this.list);
                }
                this.listStartIsRendered = true;
            }
        }

        private void renderDataList(DataList list) throws IOException {
            boolean ordered = this.isOrdered(list);
            while (this.currentIndex < list.asList().size()) {
                Data data;
                if ((data = list.get(this.currentIndex++)) instanceof DataList) {
                    this.listenTo((DataList)data, ordered && this.isStreamed((DataList)data));
                    ++this.uncompletedChildren;
                    if (!ordered) continue;
                    return;
                }
                AsynchronousSectionedRenderer.this.data(data);
            }
        }

        private void listenTo(DataList subList, boolean listenToNewDataAdded) throws IOException {
            DataListListener listListener = new DataListListener(subList, this);
            AsynchronousSectionedRenderer.this.dataListListenerStack.addFirst(listListener);
            if (listenToNewDataAdded) {
                subList.incoming().addNewDataListener((Runnable)new DataListener(listListener), AsynchronousSectionedRenderer.this.getExecutor());
            }
            this.flushIfLikelyToSuspend(subList);
            subList.addFreezeListener((Runnable)listListener, AsynchronousSectionedRenderer.this.getExecutor());
            subList.complete().addListener((Runnable)listListener, AsynchronousSectionedRenderer.this.getExecutor());
            subList.incoming().completed().addListener((Runnable)listListener, AsynchronousSectionedRenderer.this.getExecutor());
        }

        private boolean isOrdered(DataList dataList) {
            if (!(dataList instanceof Ordered)) {
                return true;
            }
            return ((Ordered)dataList).isOrdered();
        }

        private boolean isStreamed(DataList dataList) {
            if (!(dataList instanceof Streamed)) {
                return true;
            }
            return ((Streamed)dataList).isStreamed();
        }

        private void endRenderLevel(DataList<?> current) throws IOException {
            if (current instanceof ParentOfTopLevel) {
                AsynchronousSectionedRenderer.this.endResponse();
                this.closeIO(null);
            } else {
                AsynchronousSectionedRenderer.this.endList(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeIO(Exception failed) {
            IOException closeException = null;
            try {
                AsynchronousSectionedRenderer.this.stream.close();
            }
            catch (IOException e) {
                closeException = e;
                logger.log(LogLevel.WARNING, "Exception caught while closing stream to client.", e);
            }
            finally {
                if (failed != null) {
                    AsynchronousSectionedRenderer.this.success.setException((Throwable)failed);
                } else if (closeException != null) {
                    AsynchronousSectionedRenderer.this.success.setException((Throwable)closeException);
                } else {
                    AsynchronousSectionedRenderer.this.success.set((Object)true);
                }
                if (AsynchronousSectionedRenderer.this.channel != null) {
                    AsynchronousSectionedRenderer.this.channel.close(AsynchronousSectionedRenderer.this.completionHandler);
                }
            }
        }

        public String toString() {
            return "listener to " + this.list;
        }
    }
}

