/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.session.ActivationTriggers;
import com.yahoo.yolean.Exceptions;
import java.util.List;

public class ActivationTriggersSerializer {
    static final String NODE_RESTARTS = "nodeRestarts";
    static final String REINDEXINGS = "reindexings";
    static final String DEFERRED_RECONFIGURATIONS = "deferredReconfigurations";
    static final String CLUSTER_NAME = "clusterName";
    static final String DOCUMENT_TYPE = "documentType";

    public static byte[] toJson(ActivationTriggers triggers) {
        Slime root = new Slime();
        ActivationTriggersSerializer.toSlime(triggers, root.setObject());
        return (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)root));
    }

    public static ActivationTriggers fromJson(byte[] json) {
        return ActivationTriggersSerializer.fromSlime(SlimeUtils.jsonToSlime((byte[])json).get());
    }

    public static void toSlime(ActivationTriggers triggers, Cursor object) {
        Cursor nodeRestarts = object.setArray(NODE_RESTARTS);
        for (ActivationTriggers.NodeRestart nodeRestart : triggers.nodeRestarts()) {
            nodeRestarts.addString(nodeRestart.hostname());
        }
        Cursor reindexings = object.setArray(REINDEXINGS);
        for (ActivationTriggers.Reindexing reindexing : triggers.reindexings()) {
            Cursor entry = reindexings.addObject();
            entry.setString(CLUSTER_NAME, reindexing.clusterId());
            entry.setString(DOCUMENT_TYPE, reindexing.documentType());
        }
        Cursor cursor = object.setArray(DEFERRED_RECONFIGURATIONS);
        for (ActivationTriggers.DeferredReconfiguration deferred : triggers.deferredReconfigurations()) {
            cursor.addString(deferred.clusterId());
        }
    }

    public static ActivationTriggers fromSlime(Cursor object) {
        if (!object.valid()) {
            return ActivationTriggers.empty();
        }
        List<ActivationTriggers.NodeRestart> nodeRestarts = SlimeUtils.entriesStream((Inspector)object.field(NODE_RESTARTS)).map(entry -> new ActivationTriggers.NodeRestart(entry.asString())).toList();
        List<ActivationTriggers.Reindexing> reindexings = SlimeUtils.entriesStream((Inspector)object.field(REINDEXINGS)).map(entry -> new ActivationTriggers.Reindexing(entry.field(CLUSTER_NAME).asString(), entry.field(DOCUMENT_TYPE).asString())).toList();
        List<ActivationTriggers.DeferredReconfiguration> deferredReconfigurations = SlimeUtils.entriesStream((Inspector)object.field(DEFERRED_RECONFIGURATIONS)).map(entry -> new ActivationTriggers.DeferredReconfiguration(entry.asString())).toList();
        return new ActivationTriggers(nodeRestarts, reindexings, deferredReconfigurations);
    }
}

