/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import java.util.List;

public record ActivationTriggers(List<NodeRestart> nodeRestarts, List<Reindexing> reindexings, List<DeferredReconfiguration> deferredReconfigurations) {
    private static final ActivationTriggers empty = new ActivationTriggers(List.of(), List.of(), List.of());

    public static ActivationTriggers empty() {
        return empty;
    }

    public static ActivationTriggers from(ConfigChangeActions configChangeActions, boolean isInternalRedeployment) {
        RestartActions restartActions = configChangeActions.getRestartActions().useForInternalRestart(isInternalRedeployment);
        List<DeferredReconfiguration> deferredReconfigurations = restartActions.getEntries().stream().filter(RestartActions.Entry::deferChanges).map(RestartActions.Entry::getClusterName).distinct().sorted().map(DeferredReconfiguration::new).toList();
        return new ActivationTriggers(restartActions.hostnames().stream().map(NodeRestart::new).toList(), configChangeActions.getReindexActions().getEntries().stream().map(entry -> new Reindexing(entry.getClusterName(), entry.getDocumentType())).toList(), deferredReconfigurations);
    }

    public record Reindexing(String clusterId, String documentType) {
    }

    public record DeferredReconfiguration(String clusterId) {
    }

    public record NodeRestart(String hostname) {
    }
}

