/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import ai.vespa.metrics.ConfigServerMetrics;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.provision.ActivationContext;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.ApplicationMutex;
import com.yahoo.config.provision.ApplicationTransaction;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.TransientException;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.session.ActivationTriggers;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.yolean.Exceptions;
import com.yahoo.yolean.concurrent.Memoized;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private static final Duration durationBetweenResourceReadyChecks = Duration.ofSeconds(60L);
    private final Session session;
    private final ApplicationRepository applicationRepository;
    private final Supplier<PrepareParams> params;
    private final Optional<Provisioner> provisioner;
    private final Tenant tenant;
    private final DeployLogger deployLogger;
    private final Clock clock;
    private boolean prepared;
    private ConfigChangeActions configChangeActions;

    private Deployment(Session session, ApplicationRepository applicationRepository, Supplier<PrepareParams> params, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger deployLogger, Clock clock, boolean prepared) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.params = params;
        this.provisioner = provisioner;
        this.tenant = tenant;
        this.deployLogger = deployLogger;
        this.clock = clock;
        this.prepared = prepared;
    }

    public static Deployment unprepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, PrepareParams params, DeployLogger logger, Clock clock) {
        return new Deployment(session, applicationRepository, () -> params, provisioner, tenant, logger, clock, false);
    }

    public static Deployment unprepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean validate, boolean isBootstrap) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, true, isBootstrap, !validate, false, true);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, false);
    }

    public static Deployment prepared(Session session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean isBootstrap, boolean force) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, false, isBootstrap, false, force, false);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, true);
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(this.params.get().getApplicationId(), ConfigServerMetrics.DEPLOYMENT_PREPARE_MILLIS.baseName());){
            this.configChangeActions = this.sessionRepository().prepareLocalSession(this.session, this.deployLogger, this.params.get(), this.clock.instant());
            this.prepared = true;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Preparing session " + this.session.getSessionId() + " failed, deleting it");
            this.deleteSession();
            throw e;
        }
    }

    public long activate() {
        this.prepare();
        this.validateSessionStatus(this.session);
        if (this.sessionAlreadyActive(this.session)) {
            return this.configGeneration();
        }
        Deployment.waitForResourcesOrTimeout(this.params.get(), this.session, this.provisioner);
        ApplicationId applicationId = this.session.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, ConfigServerMetrics.DEPLOYMENT_ACTIVATE_MILLIS.baseName());){
            TimeoutBudget timeoutBudget = this.params.get().getTimeoutBudget();
            timeoutBudget.assertNotTimedOut(() -> "Timeout exceeded when trying to activate '" + String.valueOf(applicationId) + "'");
            this.applyDeferredReconfigurationOfClusters();
            ApplicationRepository.Activation activation = this.applicationRepository.activate(this.session, applicationId, this.tenant, this.params.get().isBootstrap(), this.params.get().force());
            this.waitForActivation(applicationId, timeoutBudget, activation);
            this.restartServicesIfNeeded(applicationId);
            this.storeReindexing(applicationId);
            long l = this.configGeneration();
            return l;
        }
    }

    private void waitForActivation(ApplicationId applicationId, TimeoutBudget timeoutBudget, ApplicationRepository.Activation activation) {
        activation.awaitCompletion(timeoutBudget.timeLeft());
        Set<FileReference> fileReferences = this.applicationRepository.getFileReferences(applicationId);
        String fileReferencesText = fileReferences.size() > 10 ? " " + fileReferences.size() + " file references" : "File references: " + String.valueOf(fileReferences);
        log.log(Level.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + this.provisioner.map(provisioner -> provisioner.getClass().getSimpleName()).orElse("no host provisioner") + ". Config generation " + this.configGeneration() + activation.sourceSessionId().stream().mapToObj(id -> ". Based on session " + id).findFirst().orElse("") + ". " + fileReferencesText);
    }

    private Long configGeneration() {
        return this.session.getMetaData().getGeneration();
    }

    private void deleteSession() {
        this.sessionRepository().deleteLocalSession(this.session.getSessionId());
        try (Transaction transaction = this.sessionRepository().createSetStatusTransaction(this.session, Session.Status.DELETE);){
            transaction.commit();
        }
    }

    private SessionRepository sessionRepository() {
        return this.tenant.getSessionRepository();
    }

    private void restartServicesIfNeeded(ApplicationId applicationId) {
        if (this.provisioner.isEmpty()) {
            return;
        }
        Set nodesToRestart = this.session.getActivationTriggers().nodeRestarts().stream().map(ActivationTriggers.NodeRestart::hostname).collect(Collectors.toSet());
        if (nodesToRestart.isEmpty()) {
            return;
        }
        this.applicationRepository.modifyPendingRestarts(applicationId, pendingRestarts -> pendingRestarts.withRestarts(this.session.getSessionId(), nodesToRestart));
        this.deployLogger.log(Level.INFO, String.format("Scheduled service restart of %d nodes: %s", nodesToRestart.size(), nodesToRestart.stream().sorted().collect(Collectors.joining(", "))));
        log.info(String.format("%sWill schedule service restart of %d nodes after convergence on generation %d: %s", this.session.logPre(), nodesToRestart.size(), this.session.getSessionId(), nodesToRestart.stream().sorted().collect(Collectors.joining(", "))));
        this.configChangeActions = this.configChangeActions == null ? null : this.configChangeActions.withRestartActions(new RestartActions());
    }

    private void storeReindexing(ApplicationId applicationId) {
        if (!this.applicationRepository.configserverConfig().hostedVespa()) {
            return;
        }
        List<ActivationTriggers.Reindexing> entries = this.session.getActivationTriggers().reindexings();
        if (entries.isEmpty()) {
            return;
        }
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> {
            for (ActivationTriggers.Reindexing entry : entries) {
                reindexing = reindexing.withPending(entry.clusterId(), entry.documentType(), this.session.getSessionId());
            }
            return reindexing;
        });
        this.deployLogger.log(Level.INFO, String.format("Scheduled reindexing of %d document types across %d clusters: %s", entries.size(), entries.stream().map(ActivationTriggers.Reindexing::clusterId).distinct().count(), entries.stream().collect(Collectors.groupingBy(ActivationTriggers.Reindexing::clusterId)).entrySet().stream().map(typesInCluster -> (String)typesInCluster.getKey() + ": " + ((List)typesInCluster.getValue()).stream().map(ActivationTriggers.Reindexing::documentType).collect(Collectors.joining(", "))).collect(Collectors.joining("; "))));
    }

    private void applyDeferredReconfigurationOfClusters() {
        Set<String> clustersWithDeferredReconfiguration = this.session.getActivationTriggers().deferredReconfigurations().stream().map(ActivationTriggers.DeferredReconfiguration::clusterId).collect(Collectors.toSet());
        if (clustersWithDeferredReconfiguration.isEmpty()) {
            return;
        }
        Model model = this.sessionRepository().getRemoteSession(this.session.getSessionId()).applicationVersions().flatMap(versions -> versions.get(this.session.getVespaVersion())).map(Application::getModel).orElseThrow(() -> new IllegalStateException("Cannot apply deferred reconfiguration: no model available for session " + this.session.getSessionId()));
        model.markClustersForDeferredReconfiguration(clustersWithDeferredReconfiguration);
        clustersWithDeferredReconfiguration.forEach(clusterName -> this.deployLogger.log(Level.INFO, "Deferring reconfiguration of cluster '%s' until restart is completed".formatted(clusterName)));
    }

    public void restart(HostFilter filter) {
        this.provisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public Session session() {
        return this.session;
    }

    public ConfigChangeActions configChangeActions() {
        if (this.configChangeActions != null) {
            return this.configChangeActions;
        }
        throw new IllegalArgumentException("No config change actions: " + (this.prepared ? "was already prepared" : "not yet prepared"));
    }

    private void validateSessionStatus(Session session) {
        long sessionId = session.getSessionId();
        if (Session.Status.NEW.equals((Object)session.getStatus())) {
            throw new IllegalArgumentException(session.logPre() + "Session " + sessionId + " is not prepared");
        }
    }

    private boolean sessionAlreadyActive(Session session) {
        return Session.Status.ACTIVATE.equals((Object)session.getStatus());
    }

    private static Supplier<PrepareParams> createPrepareParams(Clock clock, Duration timeout, Session session, boolean isInternalRedeployment, boolean isBootstrap, boolean ignoreValidationErrors, boolean force, boolean waitForResourcesInPrepare) {
        return new Memoized(() -> {
            TimeoutBudget timeoutBudget = new TimeoutBudget(clock, timeout);
            PrepareParams.Builder params = new PrepareParams.Builder().applicationId(session.getApplicationId()).vespaVersion(session.getVespaVersion().toString()).vespaVersionToBuildFirst(session.getVersionToBuildFirst()).timeoutBudget(timeoutBudget).ignoreValidationErrors(ignoreValidationErrors).isBootstrap(isBootstrap).isInternalRedeployment(isInternalRedeployment).force(force).waitForResourcesInPrepare(waitForResourcesInPrepare).tenantVaults(session.getTenantVaults()).tenantSecretStores(session.getTenantSecretStores()).dataplaneTokens(session.getDataplaneTokens());
            session.getDockerImageRepository().ifPresent(params::dockerImageRepository);
            session.getAthenzDomain().ifPresent(params::athenzDomain);
            session.getCloudAccount().ifPresent(params::cloudAccount);
            return params.build();
        });
    }

    private static void waitForResourcesOrTimeout(PrepareParams params, Session session, Optional<Provisioner> provisioner) {
        if (!params.waitForResourcesInPrepare() || provisioner.isEmpty()) {
            return;
        }
        Set preparedHosts = session.getAllocatedHosts().getHosts();
        ActivationContext context = new ActivationContext(session.getSessionId(), params.isBootstrap());
        AtomicReference<Throwable> lastException = new AtomicReference<Throwable>();
        while (true) {
            params.getTimeoutBudget().assertNotTimedOut(() -> "Timeout exceeded while waiting for application resources of '" + String.valueOf(session.getApplicationId()) + "'" + Optional.ofNullable((Exception)lastException.get()).map(e -> ". Last exception: " + Exceptions.toMessageString((Throwable)e)).orElse(""), (Exception)lastException.get());
            try (ApplicationMutex lock = provisioner.get().lock(session.getApplicationId());){
                ApplicationTransaction transaction = new ApplicationTransaction(lock, new NestedTransaction());
                provisioner.get().activate((Collection)preparedHosts, context, transaction);
                return;
            }
            catch (ApplicationLockException | TransientException e) {
                lastException.set(e);
                try {
                    Thread.sleep(durationBetweenResourceReadyChecks.toMillis());
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }
}

