/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.configchange;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigChangeRestartAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.vespa.config.server.configchange.RestartActionsFormatter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RestartActions {
    private final Map<String, Entry> actions = new TreeMap<String, Entry>();

    public RestartActions() {
    }

    private RestartActions(Map<String, Entry> actions) {
        this.actions.putAll(actions);
    }

    public RestartActions(List<ConfigChangeAction> actions) {
        for (ConfigChangeAction action : actions) {
            ConfigChangeRestartAction vra;
            if (!action.getType().equals((Object)ConfigChangeAction.Type.RESTART)) continue;
            boolean deferChanges = action instanceof ConfigChangeRestartAction && (vra = (ConfigChangeRestartAction)action).configChange() == ConfigChangeRestartAction.ConfigChange.DEFER_UNTIL_RESTART;
            for (ServiceInfo service : action.getServices()) {
                this.addEntry(service, action.ignoreForInternalRedeploy(), deferChanges).addService(service).addMessage(action.getMessage());
            }
        }
    }

    private Entry addEntry(ServiceInfo service, boolean ignoreForInternalRedeploy, boolean deferChanges) {
        String clusterName = service.getProperty("clustername").orElse("");
        String clusterType = service.getProperty("clustertype").orElse("");
        String entryId = clusterType + "." + clusterName + "." + service.getServiceType() + "." + ignoreForInternalRedeploy + "." + deferChanges;
        Entry entry = this.actions.get(entryId);
        if (entry == null) {
            entry = new Entry(clusterName, clusterType, service.getServiceType(), ignoreForInternalRedeploy, deferChanges);
            this.actions.put(entryId, entry);
        }
        return entry;
    }

    public RestartActions useForInternalRestart(boolean useForInternalRestart) {
        return new RestartActions(this.actions.entrySet().stream().filter(entry -> !useForInternalRestart || !((Entry)entry.getValue()).ignoreForInternalRedeploy()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.actions.values());
    }

    public String format() {
        return new RestartActionsFormatter(this).format();
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public Set<String> hostnames() {
        return this.getEntries().stream().flatMap(entry -> entry.getServices().stream()).map(ServiceInfo::getHostName).collect(Collectors.toUnmodifiableSet());
    }

    public static class Entry {
        private final String clusterName;
        private final String clusterType;
        private final String serviceType;
        private final boolean ignoreForInternalRedeploy;
        private final boolean deferChanges;
        private final Set<ServiceInfo> services = new LinkedHashSet<ServiceInfo>();
        private final Set<String> messages = new TreeSet<String>();

        private Entry addService(ServiceInfo service) {
            this.services.add(service);
            return this;
        }

        private void addMessage(String message) {
            this.messages.add(message);
        }

        private Entry(String clusterName, String clusterType, String serviceType, boolean ignoreForInternalRedeploy, boolean deferChanges) {
            this.clusterName = clusterName;
            this.clusterType = clusterType;
            this.serviceType = serviceType;
            this.ignoreForInternalRedeploy = ignoreForInternalRedeploy;
            this.deferChanges = deferChanges;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getClusterType() {
            return this.clusterType;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public boolean ignoreForInternalRedeploy() {
            return this.ignoreForInternalRedeploy;
        }

        public boolean deferChanges() {
            return this.deferChanges;
        }

        public Set<ServiceInfo> getServices() {
            return this.services;
        }

        public Set<String> getMessages() {
            return this.messages;
        }
    }
}

