/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import com.yahoo.component.Version;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Deployment;
import com.yahoo.config.provision.EndpointsChecker;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.io.IOUtils;
import com.yahoo.restapi.ErrorResponse;
import com.yahoo.restapi.MessageResponse;
import com.yahoo.restapi.Path;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ClusterReindexing;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.http.ContentHandler;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.ReindexingStatusException;
import com.yahoo.vespa.config.server.http.v2.request.ApplicationContentRequest;
import com.yahoo.vespa.config.server.http.v2.response.DeleteApplicationResponse;
import com.yahoo.vespa.config.server.http.v2.response.GetApplicationResponse;
import com.yahoo.vespa.config.server.http.v2.response.QuotaUsageResponse;
import com.yahoo.vespa.config.server.http.v2.response.ReindexingResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;

public class ApplicationHandler
extends HttpHandler {
    private final Zone zone;
    private final ApplicationRepository applicationRepository;

    @Inject
    public ApplicationHandler(ThreadedHttpRequestHandler.Context ctx, Zone zone, ApplicationRepository applicationRepository) {
        super(ctx);
        this.zone = zone;
        this.applicationRepository = applicationRepository;
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}")) {
            return this.getApplicationResponse(ApplicationId.from((String)path.get("tenant"), (String)path.get("application"), (String)InstanceName.defaultName().value()));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}")) {
            return this.getApplicationResponse(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/content/{*}")) {
            return this.content(ApplicationHandler.applicationId(path), path.getRest(), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/filedistributionstatus")) {
            return this.filedistributionStatus(ApplicationHandler.applicationId(path), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/active-token-fingerprints")) {
            return this.activeTokenFingerprints(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/logs")) {
            return this.logs(ApplicationHandler.applicationId(path), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/metrics/deployment")) {
            return this.deploymentMetrics(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/metrics/searchnode")) {
            return this.searchNodeMetrics(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/quota")) {
            return this.quotaUsage(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/reindexing")) {
            return this.getReindexingStatus(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/service/{service}/{hostname}/status/{*}")) {
            return this.serviceStatusPage(ApplicationHandler.applicationId(path), path.get("service"), path.get("hostname"), path.getRest(), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/service/{service}/{hostname}/state/v1/{*}")) {
            return this.serviceStateV1(ApplicationHandler.applicationId(path), path.get("service"), path.get("hostname"), path.getRest(), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/serviceconverge")) {
            return this.listServiceConverge(ApplicationHandler.applicationId(path), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/serviceconverge/{hostAndPort}")) {
            return this.checkServiceConverge(ApplicationHandler.applicationId(path), path.get("hostAndPort"), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/tester/{command}")) {
            return this.testerRequest(ApplicationHandler.applicationId(path), path.get("command"), request);
        }
        return ErrorResponse.notFoundError((String)("Nothing at " + String.valueOf(path)));
    }

    @Override
    public HttpResponse handlePOST(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/verify-endpoints")) {
            return this.verifyEndpoints(ApplicationHandler.applicationId(path), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/reindex")) {
            return this.triggerReindexing(ApplicationHandler.applicationId(path), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/reindexing")) {
            return this.enableReindexing(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/restart")) {
            return this.restart(ApplicationHandler.applicationId(path), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/tester/run/{suite}")) {
            return this.testerStartTests(ApplicationHandler.applicationId(path), path.get("suite"), request);
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/validate-secret-store")) {
            return this.validateSecretStore(ApplicationHandler.applicationId(path), request);
        }
        return ErrorResponse.notFoundError((String)("Nothing at " + String.valueOf(path)));
    }

    @Override
    public HttpResponse handlePUT(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/reindex")) {
            return this.updateReindexing(ApplicationHandler.applicationId(path), request);
        }
        return ErrorResponse.notFoundError((String)("Nothing at " + String.valueOf(path)));
    }

    @Override
    public HttpResponse handleDELETE(HttpRequest request) {
        Path path = new Path(request.getUri());
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}")) {
            return this.deleteApplication(ApplicationId.from((String)path.get("tenant"), (String)path.get("application"), (String)InstanceName.defaultName().value()));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}")) {
            return this.deleteApplication(ApplicationHandler.applicationId(path));
        }
        if (path.matches("/application/v2/tenant/{tenant}/application/{application}/environment/{ignore}/region/{ignore}/instance/{instance}/reindexing")) {
            return this.disableReindexing(ApplicationHandler.applicationId(path));
        }
        return ErrorResponse.notFoundError((String)("Nothing at " + String.valueOf(path)));
    }

    private HttpResponse listServiceConverge(ApplicationId applicationId, HttpRequest request) {
        ConfigConvergenceChecker.ServiceListResponse response = this.applicationRepository.servicesToCheckForConfigConvergence(applicationId, ApplicationHandler.getTimeoutFromRequest(request), ApplicationHandler.getVespaVersionFromRequest(request));
        return new HttpServiceListResponse(response, request.getUri());
    }

    private HttpResponse checkServiceConverge(ApplicationId applicationId, String hostAndPort, HttpRequest request) {
        ConfigConvergenceChecker.ServiceResponse response = this.applicationRepository.checkServiceForConfigConvergence(applicationId, hostAndPort, ApplicationHandler.getTimeoutFromRequest(request), ApplicationHandler.getVespaVersionFromRequest(request));
        return HttpServiceResponse.createResponse(response, hostAndPort, request.getUri());
    }

    private HttpResponse serviceStatusPage(ApplicationId applicationId, String service, String hostname, HttpURL.Path pathSuffix, HttpRequest request) {
        HttpURL.Path pathPrefix = switch (service) {
            case "container-clustercontroller" -> HttpURL.Path.empty().append("clustercontroller-status").append("v1");
            case "distributor", "storagenode" -> HttpURL.Path.empty().append("contentnode-status").append("v1");
            default -> throw new NotFoundException("No status page for service: " + service);
        };
        return this.applicationRepository.proxyServiceHostnameRequest(applicationId, hostname, service, pathPrefix.append(pathSuffix), HttpURL.Query.empty().add(request.getJDiscRequest().parameters()), null);
    }

    private HttpResponse serviceStateV1(ApplicationId applicationId, String service, String hostname, HttpURL.Path rest, HttpRequest request) {
        HttpURL.Query query = HttpURL.Query.empty().add(request.getJDiscRequest().parameters());
        String forwardedUrl = (String)query.lastEntries().get("forwarded-url");
        return this.applicationRepository.proxyServiceHostnameRequest(applicationId, hostname, service, HttpURL.Path.parse((String)"/state/v1").append(rest), query.remove("forwarded-url"), forwardedUrl == null ? null : HttpURL.from((URI)URI.create(forwardedUrl)));
    }

    private HttpResponse content(ApplicationId applicationId, HttpURL.Path contentPath, HttpRequest request) {
        long sessionId = this.applicationRepository.getSessionIdForApplication(applicationId);
        ApplicationFile applicationFile = this.applicationRepository.getApplicationFileFromSession(applicationId.tenant(), sessionId, contentPath, ContentRequest.getApplicationFileMode(request.getMethod()));
        ApplicationContentRequest contentRequest = new ApplicationContentRequest(request, sessionId, applicationId, this.zone, contentPath, applicationFile);
        return new ContentHandler().get(contentRequest);
    }

    private HttpResponse filedistributionStatus(ApplicationId applicationId, HttpRequest request) {
        return this.applicationRepository.fileDistributionStatus(applicationId, ApplicationHandler.getTimeoutFromRequest(request));
    }

    private HttpResponse activeTokenFingerprints(ApplicationId applicationId) {
        Slime slime = new Slime();
        Cursor hostsArray = slime.setObject().setArray("hosts");
        this.applicationRepository.activeTokenFingerprints(applicationId).forEach((host, tokens) -> {
            Cursor hostObject = hostsArray.addObject();
            hostObject.setString("host", host);
            Cursor tokensArray = hostObject.setArray("tokens");
            tokens.forEach(token -> {
                Cursor tokenObject = tokensArray.addObject();
                tokenObject.setString("id", token.id());
                token.fingerprints().forEach(arg_0 -> ((Cursor)tokenObject.setArray("fingerprints")).addString(arg_0));
            });
        });
        return new SlimeJsonResponse(slime);
    }

    private HttpResponse logs(ApplicationId applicationId, HttpRequest request) {
        HttpURL requestURL = HttpURL.from((URI)request.getUri());
        Optional<DomainName> hostname = Optional.ofNullable((String)requestURL.query().lastEntries().get("hostname")).map(DomainName::of);
        return this.applicationRepository.getLogs(applicationId, hostname, requestURL.query());
    }

    private HttpResponse searchNodeMetrics(ApplicationId applicationId) {
        return this.applicationRepository.getSearchNodeMetrics(applicationId);
    }

    private HttpResponse deploymentMetrics(ApplicationId applicationId) {
        return this.applicationRepository.getDeploymentMetrics(applicationId);
    }

    private HttpResponse testerRequest(ApplicationId applicationId, String command, HttpRequest request) {
        try {
            return switch (command) {
                case "status" -> this.applicationRepository.getTesterStatus(applicationId);
                case "log" -> this.applicationRepository.getTesterLog(applicationId, Long.valueOf(request.getProperty("after")));
                case "ready" -> this.applicationRepository.isTesterReady(applicationId);
                case "report" -> this.applicationRepository.getTestReport(applicationId);
                default -> throw new IllegalArgumentException("Unknown tester command in request " + request.getUri().toString());
            };
        }
        catch (ApplicationRepository.TesterSuspendedException e) {
            return HttpErrorResponse.testerSuspended(e.getMessage());
        }
    }

    private HttpResponse quotaUsage(ApplicationId applicationId) {
        double quotaUsageRate = this.applicationRepository.getQuotaUsageRate(applicationId);
        return new QuotaUsageResponse(quotaUsageRate);
    }

    private HttpResponse getApplicationResponse(ApplicationId applicationId) {
        return new GetApplicationResponse(200, this.applicationRepository.getApplicationGeneration(applicationId), this.applicationRepository.getAllVersions(applicationId), this.applicationRepository.getApplicationPackageReference(applicationId));
    }

    public HttpResponse deleteApplication(ApplicationId applicationId) {
        if (this.applicationRepository.delete(applicationId)) {
            return new DeleteApplicationResponse(applicationId);
        }
        return ErrorResponse.notFoundError((String)("Unable to delete " + applicationId.toFullString() + ": Not found"));
    }

    private Model getActiveModelOrThrow(ApplicationId id) {
        return this.applicationRepository.getActiveApplicationVersions(id).orElseThrow(() -> new NotFoundException("Application '" + String.valueOf(id) + "' not found")).getForVersionOrLatest(Optional.empty(), this.applicationRepository.clock().instant()).getModel();
    }

    private HttpResponse triggerReindexing(ApplicationId applicationId, HttpRequest request) {
        double speed = Double.parseDouble(Objects.requireNonNullElse(request.getProperty("speed"), "1"));
        String cause = Objects.requireNonNullElse(request.getProperty("cause"), "reindexing for an unknown reason");
        Instant now = this.applicationRepository.clock().instant();
        return this.modifyReindexing(applicationId, request, (original, cluster, type) -> original.withReady(cluster, type, now, speed, cause), new StringJoiner(", ", "Reindexing document types ", " of application " + String.valueOf(applicationId)).setEmptyValue("Not reindexing any document types of application " + String.valueOf(applicationId)));
    }

    private HttpResponse updateReindexing(ApplicationId applicationId, HttpRequest request) {
        String speedValue = request.getProperty("speed");
        if (speedValue == null) {
            throw new IllegalArgumentException("request must specify 'speed' parameter");
        }
        HttpResponse response = this.modifyReindexing(applicationId, request, (original, cluster, type) -> original.withSpeed(cluster, type, Double.parseDouble(speedValue)), new StringJoiner(", ", "Set reindexing speed to '" + speedValue + "' for document types ", " of application " + String.valueOf(applicationId)).setEmptyValue("Changed reindexing of no document types of application " + String.valueOf(applicationId)));
        Optional<Deployment> deployment = this.applicationRepository.deployFromLocalActive(applicationId);
        if (deployment.isPresent()) {
            this.log.log(Level.INFO, "Modified reindexing status for " + String.valueOf(applicationId) + ", deploying to make changes effective");
            deployment.get().activate();
        } else {
            this.log.log(Level.INFO, "Modified reindexing status for " + String.valueOf(applicationId) + ", but unable to deploy to make changes effective");
        }
        return response;
    }

    private HttpResponse modifyReindexing(ApplicationId applicationId, HttpRequest request, ReindexingModification modification, StringJoiner messageBuilder) {
        Model model = this.getActiveModelOrThrow(applicationId);
        Map documentTypes = model.documentTypesByCluster();
        Map indexedDocumentTypes = model.indexedDocumentTypesByCluster();
        boolean indexedOnly = request.getBooleanProperty("indexedOnly");
        Set clusters = StringUtilities.split((String)request.getProperty("clusterId"));
        Set types = StringUtilities.split((String)request.getProperty("documentType"));
        TreeMap reindexed = new TreeMap();
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> {
            for (String cluster : clusters.isEmpty() ? documentTypes.keySet() : clusters) {
                if (!documentTypes.containsKey(cluster)) {
                    throw new IllegalArgumentException("No content cluster '" + cluster + "' in application \u2014 only: " + String.join((CharSequence)", ", documentTypes.keySet()));
                }
                for (String type : types.isEmpty() ? (Set)documentTypes.get(cluster) : types) {
                    if (!((Set)documentTypes.get(cluster)).contains(type)) {
                        throw new IllegalArgumentException("No document type '" + type + "' in cluster '" + cluster + "' \u2014 only: " + String.join((CharSequence)", ", (Iterable)documentTypes.get(cluster)));
                    }
                    if (indexedOnly && !((Set)indexedDocumentTypes.get(cluster)).contains(type)) continue;
                    reindexing = modification.apply((ApplicationReindexing)reindexing, cluster, type);
                    reindexed.computeIfAbsent(cluster, __ -> new TreeSet()).add(type);
                }
            }
            return reindexing;
        });
        return new MessageResponse(reindexed.entrySet().stream().filter(cluster -> !((Set)cluster.getValue()).isEmpty()).map(cluster -> "[" + String.join((CharSequence)", ", (Iterable)cluster.getValue()) + "] in '" + (String)cluster.getKey() + "'").reduce(messageBuilder, StringJoiner::add, StringJoiner::merge).toString());
    }

    public HttpResponse disableReindexing(ApplicationId applicationId) {
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> reindexing.enabled(false));
        return new MessageResponse("Reindexing disabled");
    }

    private HttpResponse enableReindexing(ApplicationId applicationId) {
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> reindexing.enabled(true));
        return new MessageResponse("Reindexing enabled");
    }

    private HttpResponse getReindexingStatus(ApplicationId applicationId) {
        try {
            Map documentTypes = this.getActiveModelOrThrow(applicationId).documentTypesByCluster();
            ApplicationReindexing reindexing = this.applicationRepository.getReindexing(applicationId);
            Map<String, ClusterReindexing> clusters = this.applicationRepository.getClusterReindexingStatus(applicationId);
            return new ReindexingResponse(documentTypes, reindexing, clusters);
        }
        catch (UncheckedIOException e) {
            throw new ReindexingStatusException("Reindexing status for '" + String.valueOf(applicationId) + "' is currently unavailable");
        }
    }

    private HttpResponse restart(ApplicationId applicationId, HttpRequest request) {
        HostFilter filter = HostFilter.from((String)request.getProperty("hostname"), (String)request.getProperty("flavor"), (String)request.getProperty("clusterType"), (String)request.getProperty("clusterId"));
        this.applicationRepository.restart(applicationId, filter);
        return new MessageResponse("Success");
    }

    private HttpResponse verifyEndpoints(ApplicationId applicationId, HttpRequest request) {
        byte[] data = (byte[])Exceptions.uncheck(() -> request.getData().readAllBytes());
        ArrayList<EndpointsChecker.Endpoint> endpoints = new ArrayList<EndpointsChecker.Endpoint>();
        SlimeUtils.jsonToSlime((byte[])data).get().field("endpoints").traverse((__, endpointObject) -> endpoints.add(new EndpointsChecker.Endpoint(applicationId, ClusterSpec.Id.from((String)endpointObject.field("clusterName").asString()), HttpURL.from((URI)URI.create(endpointObject.field("url").asString())), SlimeUtils.optionalString((Inspector)endpointObject.field("ipAddress")).map(Exceptions.uncheck(InetAddress::getByName)), SlimeUtils.optionalString((Inspector)endpointObject.field("canonicalName")).map(DomainName::of), endpointObject.field("public").asBool(), CloudAccount.from((String)endpointObject.field("account").asString()))));
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("No endpoints in request " + String.valueOf(request));
        }
        EndpointsChecker.Availability availability = this.applicationRepository.verifyEndpoints(endpoints);
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("status", switch (availability.status()) {
            default -> throw new IncompatibleClassChangeError();
            case EndpointsChecker.Status.available -> "available";
            case EndpointsChecker.Status.endpointsUnavailable -> "endpointsUnavailable";
            case EndpointsChecker.Status.containersUnhealthy -> "containersUnhealthy";
        });
        root.setString("message", availability.message());
        return new SlimeJsonResponse(slime);
    }

    private HttpResponse testerStartTests(ApplicationId applicationId, String suite, HttpRequest request) {
        byte[] data;
        try {
            data = IOUtils.readBytes((InputStream)request.getData(), (int)1024000);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read data in request " + String.valueOf(request));
        }
        return this.applicationRepository.startTests(applicationId, suite, data);
    }

    private HttpResponse validateSecretStore(ApplicationId applicationId, HttpRequest request) {
        Slime slime = (Slime)Exceptions.uncheck(() -> SlimeUtils.jsonToSlime((byte[])request.getData().readAllBytes()));
        return this.applicationRepository.validateSecretStore(applicationId, this.zone.system(), slime);
    }

    private static ApplicationId applicationId(Path path) {
        return ApplicationId.from((String)path.get("tenant"), (String)path.get("application"), (String)path.get("instance"));
    }

    private static Duration getTimeoutFromRequest(HttpRequest request) {
        return HttpHandler.getRequestTimeout(request, Duration.ofSeconds(5L));
    }

    private static Optional<Version> getVespaVersionFromRequest(HttpRequest request) {
        return Optional.ofNullable(request.getProperty("vespaVersion")).filter(s -> !s.isEmpty()).map(Version::fromString);
    }

    static class HttpServiceListResponse
    extends JSONResponse {
        public HttpServiceListResponse(ConfigConvergenceChecker.ServiceListResponse response, URI uri) {
            super(200);
            Cursor serviceArray = this.object.setArray("services");
            response.services().forEach(service -> {
                ServiceInfo serviceInfo = service.serviceInfo;
                Cursor serviceObject = serviceArray.addObject();
                String hostName = serviceInfo.getHostName();
                int statePort = ConfigConvergenceChecker.getStatePort(serviceInfo).get();
                serviceInfo.getProperty("clustername").ifPresent(clusterName -> serviceObject.setString("clusterName", clusterName));
                serviceObject.setString("host", hostName);
                serviceObject.setLong("port", (long)statePort);
                serviceObject.setString("type", serviceInfo.getServiceType());
                serviceObject.setString("url", uri.toString() + "/" + hostName + ":" + statePort);
                serviceObject.setLong("currentGeneration", service.currentGeneration.longValue());
            });
            this.object.setString("url", uri.toString());
            this.object.setLong("currentGeneration", response.currentGeneration);
            this.object.setLong("wantedGeneration", response.wantedGeneration);
            this.object.setBool("converged", response.converged);
        }
    }

    static class HttpServiceResponse
    extends JSONResponse {
        public static HttpServiceResponse createResponse(ConfigConvergenceChecker.ServiceResponse serviceResponse, String hostAndPort, URI uri) {
            return switch (serviceResponse.status) {
                default -> throw new IncompatibleClassChangeError();
                case ConfigConvergenceChecker.ServiceResponse.Status.ok -> HttpServiceResponse.createOkResponse(uri, hostAndPort, serviceResponse.wantedGeneration, serviceResponse.currentGeneration, serviceResponse.converged);
                case ConfigConvergenceChecker.ServiceResponse.Status.hostNotFound -> HttpServiceResponse.createHostNotFoundInAppResponse(uri, hostAndPort, serviceResponse.wantedGeneration);
                case ConfigConvergenceChecker.ServiceResponse.Status.notFound -> HttpServiceResponse.createNotFoundResponse(uri, hostAndPort, serviceResponse.wantedGeneration, serviceResponse.errorMessage.orElse(""));
                case ConfigConvergenceChecker.ServiceResponse.Status.error -> HttpServiceResponse.createErrorResponse(uri, hostAndPort, serviceResponse.wantedGeneration, serviceResponse.errorMessage.orElse(""));
            };
        }

        private HttpServiceResponse(int status, URI uri, String hostname, Long wantedGeneration) {
            super(status);
            this.object.setString("url", uri.toString());
            this.object.setString("host", hostname);
            this.object.setLong("wantedGeneration", wantedGeneration.longValue());
        }

        private static HttpServiceResponse createOkResponse(URI uri, String hostname, Long wantedGeneration, Long currentGeneration, boolean converged) {
            HttpServiceResponse serviceResponse = new HttpServiceResponse(200, uri, hostname, wantedGeneration);
            serviceResponse.object.setBool("converged", converged);
            serviceResponse.object.setLong("currentGeneration", currentGeneration.longValue());
            return serviceResponse;
        }

        private static HttpServiceResponse createHostNotFoundInAppResponse(URI uri, String hostname, Long wantedGeneration) {
            HttpServiceResponse serviceResponse = new HttpServiceResponse(410, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("problem", "Host:port (service) no longer part of application, refetch list of services.");
            return serviceResponse;
        }

        private static HttpServiceResponse createErrorResponse(URI uri, String hostname, Long wantedGeneration, String error) {
            HttpServiceResponse serviceResponse = new HttpServiceResponse(500, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("error", error);
            return serviceResponse;
        }

        private static HttpServiceResponse createNotFoundResponse(URI uri, String hostname, Long wantedGeneration, String error) {
            HttpServiceResponse serviceResponse = new HttpServiceResponse(404, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("error", error);
            return serviceResponse;
        }
    }

    private static interface ReindexingModification {
        public ApplicationReindexing apply(ApplicationReindexing var1, String var2, String var3);
    }
}

