/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.NameValuePair;

class ProxyResponse
extends HttpResponse {
    private final CloseableHttpResponse clientResponse;

    ProxyResponse(CloseableHttpResponse clientResponse) {
        super(clientResponse.getCode());
        this.clientResponse = clientResponse;
    }

    public String getContentType() {
        return Optional.ofNullable(this.clientResponse.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElseGet(() -> super.getContentType());
    }

    public void render(OutputStream outputStream) throws IOException {
        try (CloseableHttpResponse closeableHttpResponse = this.clientResponse;){
            if (this.clientResponse.getEntity() != null) {
                this.clientResponse.getEntity().writeTo(outputStream);
            }
        }
    }

    public long maxPendingBytes() {
        return 0x2000000L;
    }
}

