/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.NodeAllocationException;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.QuotaExceededException;
import com.yahoo.config.provision.TransientException;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.vespa.config.server.modelfactory.AllocatedHostsFromAllModels;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.provision.ProvisionerAdapter;
import com.yahoo.vespa.config.server.provision.StaticProvisioner;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ModelsBuilder<MODELRESULT extends ModelResult> {
    private static final Logger log = Logger.getLogger(ModelsBuilder.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    protected final ConfigserverConfig configserverConfig;
    protected final boolean hosted;
    private final Zone zone;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final DeployLogger deployLogger;

    ModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, ConfigserverConfig configserverConfig, Zone zone, HostProvisionerProvider hostProvisionerProvider, DeployLogger deployLogger) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.configserverConfig = configserverConfig;
        this.hosted = configserverConfig.hostedVespa();
        this.zone = zone;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.deployLogger = deployLogger;
    }

    protected Zone zone() {
        return this.zone;
    }

    protected DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public List<MODELRESULT> buildModels(ApplicationId applicationId, Optional<DockerImage> dockerImageRepository, Version wantedNodeVespaVersion, Optional<Version> versionToBuildFirst, ApplicationPackage applicationPackage, AllocatedHostsFromAllModels allocatedHosts, Instant now) {
        Instant start = Instant.now();
        log.log(Level.FINE, () -> "Will build models for " + String.valueOf(applicationId));
        Set<Version> versions = this.findVersionsToBuild(applicationPackage);
        List<Integer> majorVersions = ModelsBuilder.majorVersionsNewestFirst(versions);
        ArrayList builtModels = new ArrayList();
        boolean buildLatestModelForThisMajor = true;
        for (int i = 0; i < majorVersions.size(); ++i) {
            int majorVersion = majorVersions.get(i);
            log.log(Level.FINE, "Building major " + majorVersion + ", versionToBuildFirst=" + String.valueOf(versionToBuildFirst));
            try {
                builtModels.addAll(this.buildModelVersions(this.keepMajorVersion(majorVersion, versions), applicationId, dockerImageRepository, wantedNodeVespaVersion, applicationPackage, allocatedHosts, now, buildLatestModelForThisMajor, versionToBuildFirst, majorVersion));
                buildLatestModelForThisMajor = false;
                versionToBuildFirst = Optional.empty();
                continue;
            }
            catch (ApplicationLockException | NodeAllocationException | QuotaExceededException | TransientException e) {
                throw e;
            }
            catch (NoSuchMethodError | RuntimeException e) {
                RuntimeException re;
                if (this.shouldSkipCreatingMajorVersionOnError(majorVersions, majorVersion, wantedNodeVespaVersion, allocatedHosts)) {
                    log.log(Level.FINE, String.valueOf(applicationId) + ": Skipping major version " + majorVersion, e);
                    continue;
                }
                if (e instanceof IllegalArgumentException || e instanceof UnsupportedOperationException) {
                    InvalidApplicationException wrapped = new InvalidApplicationException("Invalid application", e);
                    this.deployLogger.logApplicationPackage(Level.SEVERE, Exceptions.toMessageString((Throwable)wrapped));
                    throw wrapped;
                }
                log.log(Level.WARNING, "Unexpected error building " + String.valueOf(applicationId), e);
                RuntimeException ex = e instanceof RuntimeException ? (re = (RuntimeException)e) : new RuntimeException(e);
                throw new InternalServerException("Unexpected error building " + String.valueOf(applicationId), ex);
            }
        }
        log.log(Level.FINE, () -> "Done building models for " + String.valueOf(applicationId) + ". Built models for versions " + String.valueOf(builtModels.stream().map(result -> result.getModel().version()).map(Version::toFullString).collect(Collectors.toSet())) + " in " + String.valueOf(Duration.between(start, Instant.now())));
        return builtModels;
    }

    private Set<Version> findVersionsToBuild(ApplicationPackage applicationPackage) {
        Set<Version> versions = this.modelFactoryRegistry.allVersions();
        Optional requestedMajorVersion = applicationPackage.getMajorVersion();
        if (requestedMajorVersion.isPresent() && (versions = this.keepUpToMajorVersion((Integer)requestedMajorVersion.get(), versions)).isEmpty()) {
            throw new UnknownVespaVersionException("No Vespa versions on or before major version " + String.valueOf(requestedMajorVersion.get()) + " are present");
        }
        return versions;
    }

    private static List<Integer> majorVersionsNewestFirst(Set<Version> versions) {
        return versions.stream().map(Version::getMajor).distinct().sorted(Comparator.reverseOrder()).toList();
    }

    private boolean shouldSkipCreatingMajorVersionOnError(List<Integer> majorVersions, Integer majorVersion, Version wantedVersion, AllocatedHostsFromAllModels allHosts) {
        if (majorVersion.equals(wantedVersion.getMajor())) {
            return false;
        }
        if (allHosts.toAllocatedHosts().getHosts().stream().flatMap(host -> host.version().stream()).map(Version::getMajor).anyMatch(majorVersion::equals)) {
            return false;
        }
        if (majorVersion.equals(Collections.min(majorVersions))) {
            return false;
        }
        return majorVersion >= 8;
    }

    private List<MODELRESULT> buildModelVersions(Set<Version> versions, ApplicationId applicationId, Optional<DockerImage> wantedDockerImageRepository, Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, AllocatedHostsFromAllModels allocatedHosts, Instant now, boolean buildLatestModelForThisMajor, Optional<Version> versionToBuildFirst, int majorVersion) {
        ArrayList<MODELRESULT> built = new ArrayList<MODELRESULT>();
        if (buildLatestModelForThisMajor) {
            if (versionToBuildFirst.isEmpty()) {
                versionToBuildFirst = Optional.of(this.findLatest(versions));
            }
            MODELRESULT builtFirst = this.buildModelVersion(this.modelFactoryRegistry.getFactory(versionToBuildFirst.get()), applicationPackage, applicationId, wantedDockerImageRepository, wantedNodeVespaVersion);
            allocatedHosts.add(builtFirst.getModel().allocatedHosts(), versionToBuildFirst.get());
            built.add(builtFirst);
        }
        versions = this.versionsToBuild(versions, wantedNodeVespaVersion, majorVersion, allocatedHosts);
        for (Version version : versions) {
            if (ModelsBuilder.alreadyBuilt(version, built)) continue;
            try {
                MODELRESULT modelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory(version), applicationPackage, applicationId, wantedDockerImageRepository, wantedNodeVespaVersion);
                allocatedHosts.add(modelVersion.getModel().allocatedHosts(), version);
                built.add(modelVersion);
            }
            catch (RuntimeException e) {
                if (this.allowBuildToFail(now, built)) {
                    log.log(Level.INFO, String.valueOf(applicationId) + ": Failed to build version " + String.valueOf(version) + ", but allow failure due to validation override or manual deployment:" + Exceptions.toMessageString((Throwable)e));
                    continue;
                }
                log.log(Level.SEVERE, String.valueOf(applicationId) + ": Failed to build version " + String.valueOf(version));
                throw e;
            }
        }
        return built;
    }

    private boolean allowBuildToFail(Instant now, List<MODELRESULT> built) {
        return !built.isEmpty() && (((ModelResult)built.get(0)).getModel().skipOldConfigModels(now) || this.zone().environment().isManuallyDeployed());
    }

    private static <MODELRESULT extends ModelResult> boolean alreadyBuilt(Version version, List<MODELRESULT> built) {
        return built.stream().map(modelresult -> modelresult.getModel().version()).anyMatch(arg_0 -> ((Version)version).equals(arg_0));
    }

    private Set<Version> versionsToBuild(Set<Version> versions, Version wantedVersion, int majorVersion, AllocatedHostsFromAllModels allocatedHosts) {
        versions = this.keepThoseUsedOn(allocatedHosts.toAllocatedHosts(), versions);
        if (this.hosted && wantedVersion.getMajor() == majorVersion) {
            versions.add(wantedVersion);
        }
        return versions;
    }

    private Set<Version> keepMajorVersion(int majorVersion, Set<Version> versions) {
        return versions.stream().filter(v -> v.getMajor() == majorVersion).collect(Collectors.toSet());
    }

    private Set<Version> keepUpToMajorVersion(int majorVersion, Set<Version> versions) {
        return versions.stream().filter(v -> v.getMajor() <= majorVersion).collect(Collectors.toSet());
    }

    private Version findLatest(Set<Version> versionSet) {
        ArrayList<Version> versionList = new ArrayList<Version>(versionSet);
        Collections.sort(versionList);
        return (Version)versionList.get(versionList.size() - 1);
    }

    private Set<Version> keepThoseUsedOn(AllocatedHosts hosts, Set<Version> versions) {
        return versions.stream().filter(version -> this.isUsedOn(hosts, (Version)version)).collect(Collectors.toSet());
    }

    private boolean isUsedOn(AllocatedHosts hosts, Version version) {
        return hosts.getHosts().stream().anyMatch(host -> host.version().isPresent() && ((Version)host.version().get()).equals((Object)version));
    }

    protected abstract MODELRESULT buildModelVersion(ModelFactory var1, ApplicationPackage var2, ApplicationId var3, Optional<DockerImage> var4, Version var5);

    HostProvisioner createStaticProvisioner(ApplicationPackage applicationPackage, ApplicationId applicationId, Provisioned provisioned) {
        Optional allocatedHosts = applicationPackage.getAllocatedHosts();
        if (this.hosted && allocatedHosts.isPresent()) {
            return this.createStaticProvisionerForHosted((AllocatedHosts)allocatedHosts.get(), this.createNodeRepositoryProvisioner(applicationId, provisioned).get());
        }
        return DeployState.getDefaultModelHostProvisioner((ApplicationPackage)applicationPackage);
    }

    HostProvisioner createStaticProvisionerForHosted(AllocatedHosts allocatedHosts, HostProvisioner nodeRepositoryProvisioner) {
        return new StaticProvisioner(allocatedHosts, nodeRepositoryProvisioner);
    }

    Optional<HostProvisioner> createNodeRepositoryProvisioner(ApplicationId applicationId, Provisioned provisioned) {
        return this.hostProvisionerProvider.getHostProvisioner().map(provisioner -> new ProvisionerAdapter((Provisioner)provisioner, applicationId, provisioned));
    }
}

