/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.component.annotation.Inject;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.response.SessionActiveResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.time.Duration;
import java.util.logging.Level;

public class SessionActiveHandler
extends SessionHandler {
    private static final Duration DEFAULT_ACTIVATE_TIMEOUT = Duration.ofMinutes(2L);
    private final TenantRepository tenantRepository;
    private final Zone zone;

    @Inject
    public SessionActiveHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository, Zone zone) {
        super(ctx, applicationRepository);
        this.tenantRepository = applicationRepository.tenantRepository();
        this.zone = zone;
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        TimeoutBudget timeoutBudget = SessionActiveHandler.getTimeoutBudget(request, DEFAULT_ACTIVATE_TIMEOUT);
        long sessionId = SessionActiveHandler.getSessionIdV2(request);
        ApplicationId applicationId = this.applicationRepository.activate(tenant, sessionId, timeoutBudget, SessionActiveHandler.shouldIgnoreSessionStaleFailure(request));
        ApplicationMetaData metaData = this.applicationRepository.getMetadataFromLocalSession(tenant, sessionId);
        return new SessionActiveResponse(metaData.getSlime(), request, applicationId, sessionId, this.zone);
    }

    public void handleTimeout(Request request, ResponseHandler responseHandler) {
        this.log.log(Level.SEVERE, "activate timed out for " + String.valueOf(request.getUri()), new RuntimeException("activate timed out"));
        super.handleTimeout(request, responseHandler);
    }
}

