/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.utils.MultiPartFormParser;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.restapi.MessageResponse;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.PrepareAndActivateResult;
import com.yahoo.vespa.config.server.http.v2.SessionCreateHandler;
import com.yahoo.vespa.config.server.http.v2.response.SessionPrepareAndActivateResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.hc.core5.http.ContentType;

public class ApplicationApiHandler
extends SessionHandler {
    public static final String APPLICATION_X_GZIP = "application/x-gzip";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_PARAMS = "prepareParams";
    public static final String MULTIPART_APPLICATION_PACKAGE = "applicationPackage";
    public static final String contentTypeHeader = "Content-Type";
    private final TenantRepository tenantRepository;
    private final Duration zookeeperBarrierTimeout;
    private final long maxApplicationPackageSize;
    private final Zone zone;
    private final MultiPartFormParser multiPartFormParser;

    @Inject
    public ApplicationApiHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository, ConfigserverConfig configserverConfig, Zone zone) {
        this(ctx, applicationRepository, configserverConfig, zone, new MultiPartFormParser(Paths.get(Defaults.getDefaults().underVespaHome("var/tmp/jetty-multiform-part-data"), new String[0]), -1L));
    }

    ApplicationApiHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository, ConfigserverConfig configserverConfig, Zone zone, MultiPartFormParser multiPartFormParser) {
        super(ctx, applicationRepository);
        this.tenantRepository = applicationRepository.tenantRepository();
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
        this.maxApplicationPackageSize = configserverConfig.maxApplicationPackageSize();
        this.zone = zone;
        this.multiPartFormParser = multiPartFormParser;
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        TenantName tenantName = this.validateTenant(request);
        long sessionId = ApplicationApiHandler.getSessionIdFromRequest(request);
        ApplicationId app = this.applicationRepository.activate(this.tenantRepository.getTenant(tenantName), sessionId, ApplicationApiHandler.getTimeoutBudget(request, Duration.ofMinutes(2L)), ApplicationApiHandler.shouldIgnoreSessionStaleFailure(request));
        return new MessageResponse("Session " + sessionId + " for " + app.toFullString() + " activated");
    }

    @Override
    protected HttpResponse handlePOST(HttpRequest request) {
        SessionPrepareAndActivateResponse sessionPrepareAndActivateResponse;
        block20: {
            CompressedApplicationInputStream compressedStream;
            PrepareParams prepareParams;
            Object parts;
            SessionCreateHandler.validateDataAndHeader(request, List.of(APPLICATION_X_GZIP, APPLICATION_ZIP, MULTIPART_FORM_DATA));
            TenantName tenantName = this.validateTenant(request);
            boolean multipartRequest = Optional.ofNullable(request.getHeader(contentTypeHeader)).map(ContentType::parse).map(contentType -> contentType.getMimeType().equalsIgnoreCase(MULTIPART_FORM_DATA)).orElse(false);
            if (multipartRequest) {
                parts = Map.of();
                try {
                    byte[] params;
                    parts = this.multiPartFormParser.readParts(request);
                    try (InputStream part = ((MultiPartFormParser.PartItem)parts.get(MULTIPART_PARAMS)).data();){
                        params = part.readAllBytes();
                    }
                    this.log.log(Level.FINE, "Deploy parameters: [{0}]", new String(params, StandardCharsets.UTF_8));
                    prepareParams = PrepareParams.fromJson(params, tenantName, this.zookeeperBarrierTimeout, ((BooleanFlag)PermanentFlags.VERBOSE_DEPLOY_PARAMETER.bindTo(this.applicationRepository.flagSource())).value());
                    MultiPartFormParser.PartItem appPackagePart = (MultiPartFormParser.PartItem)parts.get(MULTIPART_APPLICATION_PACKAGE);
                    compressedStream = CompressedApplicationInputStream.createFromCompressedStream(appPackagePart.data(), appPackagePart.contentType(), this.maxApplicationPackageSize);
                }
                catch (IOException e2) {
                    String message = "Deploy request from '" + tenantName.value() + "' contains invalid data: " + e2.getMessage();
                    if (e2 instanceof MultiPartFormParser.MultiPartException) {
                        this.log.log(Level.INFO, "Unable to parse multipart in deploy from tenant '" + tenantName.value() + "': " + Exceptions.toMessageString((Throwable)e2) + ". This is usually caused by controller abandoning request while streaming data to config server");
                    } else {
                        this.log.log(Level.INFO, message + ", parts: " + String.valueOf(parts), e2);
                    }
                    throw new BadRequestException(message);
                }
            }
            prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
            compressedStream = CompressedApplicationInputStream.createFromCompressedStream(request.getData(), request.getHeader(contentTypeHeader), this.maxApplicationPackageSize);
            request.getAccessLogEntry().ifPresent(e -> e.addKeyValue("app.id", prepareParams.getApplicationId().toFullString()));
            parts = compressedStream;
            try {
                PrepareAndActivateResult result = this.applicationRepository.deploy(compressedStream, prepareParams);
                sessionPrepareAndActivateResponse = new SessionPrepareAndActivateResponse(result, prepareParams.getApplicationId(), request, this.zone);
                if (parts == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (parts != null) {
                        try {
                            ((CompressedApplicationInputStream)parts).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new UncheckedIOException(e3);
                }
            }
            ((CompressedApplicationInputStream)parts).close();
        }
        return sessionPrepareAndActivateResponse;
    }

    @Override
    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(180L));
    }

    private TenantName validateTenant(HttpRequest request) {
        TenantName tenantName = ApplicationApiHandler.getTenantNameFromRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        return tenantName;
    }

    public static TenantName getTenantNameFromRequest(HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/prepareandactivate*");
        return TenantName.from((String)bm.group(2));
    }

    public static long getSessionIdFromRequest(HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/prepareandactivate/*");
        try {
            return Long.parseLong(bm.group(3));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Session id '" + bm.group(3) + "' is not a number: " + e.getMessage());
        }
    }
}

