/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.filedistribution.FileServer;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final File downloadDirectory;
    private final FileDownloader fileDownloader;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FileServer fileServer) {
        super(applicationRepository, curator, applicationRepository.flagSource(), applicationRepository.clock(), interval, false);
        String fileReferencesDir = applicationRepository.configserverConfig().fileReferencesDir();
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(fileReferencesDir));
        this.fileDownloader = fileServer.downloader();
    }

    protected double maintain() {
        int attempts = 0;
        int[] failures = new int[1];
        ArrayList<Runnable> futureDownloads = new ArrayList<Runnable>();
        for (Session session : this.preparedAndActivatedSessions()) {
            log.log(Level.FINE, () -> "Considering session " + session.getSessionId());
            if (this.shuttingDown()) {
                return this.asSuccessFactorDeviation(attempts, failures[0]);
            }
            ApplicationId applicationId = session.getOptionalApplicationId().orElse(null);
            if (applicationId == null) continue;
            Optional<FileReference> appFileReference = session.getApplicationPackageReference();
            log.log(Level.FINE, () -> "Application package reference: " + String.valueOf(appFileReference));
            if (!appFileReference.isPresent()) continue;
            long sessionId = session.getSessionId();
            FileReference fileReference = appFileReference.get();
            ++attempts;
            if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, fileReference)) {
                log.log(Level.FINE, () -> "Application package reference: " + String.valueOf(appFileReference.get()) + " not on disk, downloading");
                Future<Optional<File>> futureDownload = this.startDownload(fileReference, sessionId, applicationId);
                futureDownloads.add(() -> {
                    try {
                        if (((Optional)futureDownload.get()).isPresent()) {
                            this.createLocalSessionIfMissing(applicationId, sessionId);
                            return;
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Exception when downloading application package (" + String.valueOf(fileReference) + ") for " + String.valueOf(applicationId) + " (session " + sessionId + "): " + e.getMessage());
                    }
                    failures[0] = failures[0] + 1;
                    this.logFailure(session, fileReference, applicationId);
                });
                continue;
            }
            this.createLocalSessionIfMissing(applicationId, sessionId);
        }
        futureDownloads.forEach(Runnable::run);
        return this.asSuccessFactorDeviation(attempts, failures[0]);
    }

    private Future<Optional<File>> startDownload(FileReference fileReference, long sessionId, ApplicationId applicationId) {
        log.log(Level.FINE, () -> "Downloading application package with " + String.valueOf(fileReference) + " for " + String.valueOf(applicationId) + " (session " + sessionId + ")");
        return this.fileDownloader.getFutureFileOrTimeout(new FileReferenceDownload(fileReference, ((Object)((Object)this)).getClass().getSimpleName(), false));
    }

    private Collection<RemoteSession> preparedAndActivatedSessions() {
        TenantRepository tenantRepository = this.applicationRepository.tenantRepository();
        return tenantRepository.getAllTenantNames().stream().map(tenantRepository::getTenant).map(t -> t.getSessionRepository().getRemoteSessions()).flatMap(Collection::stream).filter(s -> s.getStatus() == Session.Status.PREPARE || s.getStatus() == Session.Status.ACTIVATE).toList();
    }

    public void awaitShutdown() {
        this.fileDownloader.close();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }

    private void logFailure(Session session, FileReference fileReference, ApplicationId applicationId) {
        Instant deployed = Instant.ofEpochMilli(session.getMetaData().getDeployTimestamp());
        Level level = Duration.between(deployed, this.applicationRepository.clock().instant()).toMinutes() > 2L ? Level.INFO : Level.FINE;
        log.log(level, "Downloading application package (" + String.valueOf(fileReference) + ") for " + String.valueOf(applicationId) + " (session " + session.getSessionId() + ") unsuccessful.");
    }
}

