/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.host;

import com.google.common.collect.Collections2;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.host.HostValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HostRegistry
implements HostValidator {
    private static final Logger log = Logger.getLogger(HostRegistry.class.getName());
    private final Map<String, ApplicationId> host2ApplicationId = new ConcurrentHashMap<String, ApplicationId>();

    public ApplicationId getApplicationId(String hostName) {
        return this.host2ApplicationId.get(hostName);
    }

    public synchronized void update(ApplicationId key, Collection<String> newHosts) {
        this.verifyHosts(key, newHosts);
        Collection<String> currentHosts = this.getHosts(key);
        log.log(Level.FINE, () -> "Setting hosts for key '" + String.valueOf(key) + "', newHosts: " + String.valueOf(newHosts) + ", currentHosts: " + String.valueOf(currentHosts));
        Collection<String> removedHosts = HostRegistry.findRemovedHosts(newHosts, currentHosts);
        this.removeHosts(removedHosts);
        this.addHosts(key, newHosts);
    }

    @Override
    public synchronized void verifyHosts(ApplicationId applicationId, Collection<String> newHosts) {
        for (String host : newHosts) {
            if (!this.hostAlreadyTaken(host, applicationId)) continue;
            String message = "'" + String.valueOf(applicationId) + "' tried to allocate '" + host + "', but the host is already allocated to another application";
            log.log(Level.SEVERE, () -> message + " (' " + String.valueOf(this.host2ApplicationId.get(host)) + "')");
            throw new IllegalArgumentException(message);
        }
    }

    public synchronized void removeHosts(ApplicationId key) {
        this.host2ApplicationId.entrySet().removeIf(entry -> ((ApplicationId)entry.getValue()).equals((Object)key));
    }

    public synchronized void removeHosts(TenantName key) {
        this.host2ApplicationId.entrySet().removeIf(entry -> ((ApplicationId)entry.getValue()).tenant().equals((Object)key));
    }

    public synchronized Collection<String> getAllHosts() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.host2ApplicationId.keySet()));
    }

    public synchronized Collection<String> getHosts(ApplicationId key) {
        return this.host2ApplicationId.entrySet().stream().filter(entry -> ((ApplicationId)entry.getValue()).equals((Object)key)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private boolean hostAlreadyTaken(String host, ApplicationId key) {
        return this.host2ApplicationId.containsKey(host) && !key.equals((Object)this.host2ApplicationId.get(host));
    }

    private static Collection<String> findRemovedHosts(Collection<String> newHosts, Collection<String> previousHosts) {
        return Collections2.filter(previousHosts, host -> !newHosts.contains(host));
    }

    private void removeHosts(Collection<String> removedHosts) {
        for (String host : removedHosts) {
            log.log(Level.FINE, () -> "Removing " + host);
            this.host2ApplicationId.remove(host);
        }
    }

    private void addHosts(ApplicationId key, Collection<String> newHosts) {
        for (String host : newHosts) {
            log.log(Level.FINE, () -> "Adding " + host);
            this.host2ApplicationId.put(host, key);
        }
    }
}

