/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.vespa.archive.ArchiveStreamReader;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompressedApplicationInputStream
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(CompressedApplicationInputStream.class.getPackage().getName());
    private final ArchiveStreamReader reader;

    private CompressedApplicationInputStream(ArchiveStreamReader reader) {
        this.reader = reader;
    }

    public static CompressedApplicationInputStream createFromCompressedStream(InputStream is, String contentType, long maxSizeInBytes) {
        try {
            ArchiveStreamReader.Options options = ArchiveStreamReader.Options.standard().maxSize(maxSizeInBytes).allowDotSegment(true);
            return switch (contentType) {
                case "application/x-gzip" -> new CompressedApplicationInputStream(ArchiveStreamReader.ofTarGzip((InputStream)is, (ArchiveStreamReader.Options)options));
                case "application/zip" -> new CompressedApplicationInputStream(ArchiveStreamReader.ofZip((InputStream)is, (ArchiveStreamReader.Options)options));
                default -> throw new BadRequestException("Unable to decompress");
            };
        }
        catch (UncheckedIOException e) {
            throw new InternalServerException("Unable to create compressed application stream", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    File decompress() throws IOException {
        return this.decompress(((Path)Exceptions.uncheck(() -> Files.createTempDirectory("decompress", new FileAttribute[0]))).toFile());
    }

    public File decompress(File dir) throws IOException {
        try {
            return this.decompressInto(dir.toPath());
        }
        catch (IOException e) {
            throw new IOException("Unable to decompress stream into " + dir.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File decompressInto(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + String.valueOf(dir.toAbsolutePath()));
        }
        String absolutePath = dir.toFile().getAbsolutePath();
        log.log(Level.FINE, () -> "Decompress application into " + absolutePath);
        int entries = 0;
        Path tmpFile = null;
        OutputStream tmpStream = null;
        try {
            ArchiveStreamReader.ArchiveFile file;
            tmpFile = CompressedApplicationInputStream.createTempFile(dir);
            tmpStream = Files.newOutputStream(tmpFile, new OpenOption[0]);
            while ((file = this.reader.readNextTo(tmpStream)) != null) {
                tmpStream.close();
                log.log(Level.FINE, "Creating output file: " + String.valueOf(file.path()));
                Path dstFile = dir.resolve(file.path().toString()).normalize();
                Files.createDirectories(dstFile.getParent(), new FileAttribute[0]);
                Files.move(tmpFile, dstFile, new CopyOption[0]);
                tmpFile = CompressedApplicationInputStream.createTempFile(dir);
                tmpStream = Files.newOutputStream(tmpFile, new OpenOption[0]);
                ++entries;
            }
        }
        finally {
            if (tmpStream != null) {
                tmpStream.close();
            }
            if (tmpFile != null) {
                Files.deleteIfExists(tmpFile);
            }
        }
        if (entries == 0) {
            log.log(Level.WARNING, "Unable to decompress any entries into " + absolutePath);
        }
        return dir.toFile();
    }

    private static Path createTempFile(Path applicationDir) throws IOException {
        return Files.createTempFile(applicationDir, "application", null, new FileAttribute[0]);
    }
}

