/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.config.model.api.EndpointCertificateSecretStore;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.stream.CustomCollectors;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EndpointCertificateRetriever {
    private final List<EndpointCertificateSecretStore> secretStores;
    private static final Logger log = Logger.getLogger(EndpointCertificateRetriever.class.getName());

    public EndpointCertificateRetriever(List<EndpointCertificateSecretStore> secretStores) {
        this.secretStores = List.copyOf(secretStores);
    }

    public Optional<EndpointCertificateSecrets> readEndpointCertificateSecrets(EndpointCertificateMetadata metadata) {
        return Optional.of(this.readFromSecretStore(metadata));
    }

    private EndpointCertificateSecrets readFromSecretStore(EndpointCertificateMetadata endpointCertificateMetadata) {
        try {
            EndpointCertificateSecrets endpointCertificateSecrets = ((EndpointCertificateSecretStore)((Optional)this.secretStores.stream().filter(store -> store.supports(endpointCertificateMetadata.issuer())).collect(CustomCollectors.singleton())).orElseThrow(() -> new RuntimeException("No provider of secrets for issuer " + String.valueOf(endpointCertificateMetadata.issuer())))).getSecret(endpointCertificateMetadata);
            if (endpointCertificateSecrets.isMissing()) {
                return endpointCertificateSecrets;
            }
            this.verifyKeyMatchesCertificate(endpointCertificateMetadata, endpointCertificateSecrets);
            return endpointCertificateSecrets;
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Exception thrown during certificate retrieval", e);
            return EndpointCertificateSecrets.missing((int)endpointCertificateMetadata.version());
        }
    }

    private void verifyKeyMatchesCertificate(EndpointCertificateMetadata endpointCertificateMetadata, EndpointCertificateSecrets endpointCertificateSecrets) {
        PublicKey publicKey;
        X509Certificate x509Certificate = X509CertificateUtils.fromPem((String)endpointCertificateSecrets.certificate());
        PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey((String)endpointCertificateSecrets.key());
        if (!X509CertificateUtils.privateKeyMatchesPublicKey((PrivateKey)privateKey, (PublicKey)(publicKey = x509Certificate.getPublicKey()))) {
            throw new IllegalArgumentException("Failed to retrieve endpoint secrets: Certificate and key data do not match for " + String.valueOf(endpointCertificateMetadata));
        }
    }
}

