/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelCreateResult;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.OnnxModelCost;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.NodeAllocationException;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationCuratorDatabase;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.modelfactory.LegacyFlags;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.modelfactory.ModelsBuilder;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreparedModelsBuilder
extends ModelsBuilder<PreparedModelResult> {
    private static final Logger log = Logger.getLogger(PreparedModelsBuilder.class.getName());
    private final FlagSource flagSource;
    private final List<ContainerEndpoint> containerEndpoints;
    private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final HostValidator hostValidator;
    private final PrepareParams params;
    private final FileRegistry fileRegistry;
    private final Optional<ApplicationVersions> activeApplicationVersions;
    private final Curator curator;
    private final ExecutorService executor;
    private final OnnxModelCost onnxModelCost;

    public PreparedModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, FlagSource flagSource, List<ContainerEndpoint> containerEndpoints, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, ExecutorService executor, HostProvisionerProvider hostProvisionerProvider, Curator curator, HostValidator hostValidator, DeployLogger deployLogger, PrepareParams params, Optional<ApplicationVersions> activeApplicationVersions, ConfigserverConfig configserverConfig, Zone zone, OnnxModelCost onnxModelCost) {
        super(modelFactoryRegistry, configserverConfig, zone, hostProvisionerProvider, deployLogger);
        this.flagSource = flagSource;
        this.containerEndpoints = containerEndpoints;
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.hostValidator = hostValidator;
        this.curator = curator;
        this.params = params;
        this.activeApplicationVersions = activeApplicationVersions;
        this.executor = executor;
        this.onnxModelCost = onnxModelCost;
    }

    @Override
    protected PreparedModelResult buildModelVersion(ModelFactory modelFactory, ApplicationPackage applicationPackage, ApplicationId applicationId, Optional<DockerImage> wantedDockerImageRepository, Version wantedNodeVespaVersion) {
        Version modelVersion = modelFactory.version();
        log.log(Level.FINE, () -> "Building model " + String.valueOf(modelVersion) + " for " + String.valueOf(applicationId));
        Provisioned provisioned = new Provisioned();
        ModelContextImpl modelContext = new ModelContextImpl(applicationPackage, this.modelOf(modelVersion), this.deployLogger(), this.configDefinitionRepo, this.fileRegistry, this.executor, new ApplicationCuratorDatabase(applicationId.tenant(), this.curator).readReindexingStatus(applicationId), this.createHostProvisioner(applicationPackage, provisioned), provisioned, this.createModelContextProperties(modelFactory.version(), applicationPackage), this.getAppDir(applicationPackage), this.onnxModelCost, wantedDockerImageRepository, modelVersion, wantedNodeVespaVersion);
        ModelCreateResult result = this.createAndValidateModel(modelFactory, applicationId, modelVersion, modelContext);
        return new PreparedModelResult(modelVersion, result.getModel(), this.fileRegistry, result.getConfigChangeActions());
    }

    private ModelCreateResult createAndValidateModel(ModelFactory modelFactory, ApplicationId applicationId, Version modelVersion, ModelContext modelContext) {
        log.log(Level.FINE, () -> "Create and validate model " + String.valueOf(modelVersion) + " for " + String.valueOf(applicationId) + ", previous model " + (this.modelOf(modelVersion).isPresent() ? " exists" : "does not exist"));
        ValidationParameters validationParameters = new ValidationParameters(this.params.ignoreValidationErrors() ? ValidationParameters.IgnoreValidationErrors.TRUE : ValidationParameters.IgnoreValidationErrors.FALSE);
        ModelCreateResult result = modelFactory.createAndValidateModel(modelContext, validationParameters);
        this.validateModelHosts(this.hostValidator, applicationId, result.getModel());
        log.log(Level.FINE, () -> "Done building model " + String.valueOf(modelVersion) + " for " + String.valueOf(applicationId));
        this.params.getTimeoutBudget().assertNotTimedOut(() -> "prepare timed out after building model " + String.valueOf(modelVersion) + " (timeout " + String.valueOf(this.params.getTimeoutBudget().timeout()) + "): " + String.valueOf(applicationId));
        return result;
    }

    private Optional<Model> modelOf(Version version) {
        if (this.activeApplicationVersions.isEmpty()) {
            return Optional.empty();
        }
        return this.activeApplicationVersions.get().get(version).map(Application::getModel);
    }

    private HostProvisioner createHostProvisioner(ApplicationPackage applicationPackage, Provisioned provisioned) {
        HostProvisioner defaultHostProvisioner = DeployState.getDefaultModelHostProvisioner((ApplicationPackage)applicationPackage);
        Optional<HostProvisioner> nodeRepositoryProvisioner = this.createNodeRepositoryProvisioner(this.params.getApplicationId(), provisioned);
        Optional allocatedHosts = applicationPackage.getAllocatedHosts();
        if (allocatedHosts.isEmpty()) {
            return nodeRepositoryProvisioner.orElse(defaultHostProvisioner);
        }
        if (this.hosted) {
            return this.createStaticProvisionerForHosted((AllocatedHosts)allocatedHosts.get(), nodeRepositoryProvisioner.get());
        }
        return defaultHostProvisioner;
    }

    private Optional<File> getAppDir(ApplicationPackage applicationPackage) {
        try {
            return applicationPackage instanceof FilesApplicationPackage ? Optional.of(((FilesApplicationPackage)applicationPackage).getAppDir()) : Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find app dir", e);
        }
    }

    private void validateModelHosts(HostValidator hostValidator, ApplicationId applicationId, Model model) {
        Instant end = Instant.now().plus(Duration.ofSeconds(1L));
        while (true) {
            try {
                hostValidator.verifyHosts(applicationId, model.getHosts().stream().map(HostInfo::getHostname).toList());
                return;
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException exception = e;
                log.log(Level.INFO, "Verifying hosts failed, will retry: " + e.getMessage());
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Instant.now().isBefore(end)) continue;
                if (this.configserverConfig.hostedVespa()) {
                    throw new NodeAllocationException(Exceptions.toMessageString((Throwable)exception), true);
                }
                throw exception;
            }
            break;
        }
    }

    private ModelContext.Properties createModelContextProperties(Version modelVersion, ApplicationPackage applicationPackage) {
        return new ModelContextImpl.Properties(this.params.getApplicationId(), modelVersion, this.configserverConfig, this.zone(), Set.copyOf(this.containerEndpoints), this.params.isBootstrap(), this.activeApplicationVersions.isEmpty(), LegacyFlags.from(applicationPackage, this.flagSource), this.endpointCertificateSecrets, this.params.athenzDomain(), this.params.quota(), this.params.tenantVaults(), this.params.tenantSecretStores(), this.params.operatorCertificates(), this.params.cloudAccount(), this.params.dataplaneTokens());
    }

    public static class PreparedModelResult
    implements ModelResult {
        public final Version version;
        public final Model model;
        public final FileRegistry fileRegistry;
        public final List<ConfigChangeAction> actions;

        public PreparedModelResult(Version version, Model model, FileRegistry fileRegistry, List<ConfigChangeAction> actions) {
            this.version = version;
            this.model = model;
            this.fileRegistry = fileRegistry;
            this.actions = actions;
        }

        @Override
        public Model getModel() {
            return this.model;
        }
    }
}

