/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.http.HttpURL;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.SessionContentListResponse;
import com.yahoo.vespa.config.server.http.SessionContentReadResponse;
import com.yahoo.vespa.config.server.http.SessionContentStatusListResponse;
import com.yahoo.vespa.config.server.http.SessionContentStatusResponse;
import java.util.Collections;
import java.util.List;

public class ContentHandler {
    public HttpResponse get(ContentRequest request) {
        ContentRequest.ReturnType returnType = request.getReturnType();
        String urlBase = request.getUrlBase("/content/");
        return ContentRequest.ReturnType.STATUS.equals((Object)returnType) ? this.status(request, urlBase) : this.content(request, urlBase);
    }

    public HttpResponse put(ContentRequest request) {
        ApplicationFile file = request.getFile();
        if (request.getPath().hasTrailingSlash()) {
            this.createDirectory(request, file);
        } else {
            this.createFile(request, file);
        }
        return this.createResponse(request);
    }

    public HttpResponse delete(ContentRequest request) {
        ApplicationFile file = request.getExistingFile();
        this.deleteFile(file);
        return this.createResponse(request);
    }

    private HttpResponse content(ContentRequest request, String urlBase) {
        ApplicationFile file = request.getExistingFile();
        if (file.isDirectory()) {
            return new SessionContentListResponse(urlBase, ContentHandler.listSortedFiles(file, request.getPath(), request.isRecursive()));
        }
        return new SessionContentReadResponse(file);
    }

    private HttpResponse status(ContentRequest request, String urlBase) {
        ApplicationFile file = request.getFile();
        if (file.isDirectory()) {
            return new SessionContentStatusListResponse(urlBase, ContentHandler.listSortedFiles(file, request.getPath(), request.isRecursive()));
        }
        return new SessionContentStatusResponse(file, urlBase);
    }

    private static List<ApplicationFile> listSortedFiles(ApplicationFile file, HttpURL.Path path, boolean recursive) {
        if (path.length() > 0 && !path.hasTrailingSlash()) {
            return List.of(file);
        }
        List files = file.listFiles(recursive);
        Collections.sort(files);
        return files;
    }

    private void createFile(ContentRequest request, ApplicationFile file) {
        if (!request.hasRequestBody()) {
            throw new BadRequestException("Request must contain body when creating a file");
        }
        try {
            file.writeFile(request.getData());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createDirectory(ContentRequest request, ApplicationFile file) {
        if (request.hasRequestBody()) {
            // empty if block
        }
        file.createDirectory();
    }

    private void deleteFile(ApplicationFile file) {
        try {
            file.delete();
        }
        catch (RuntimeException e) {
            throw new BadRequestException("File '" + String.valueOf(file.getPath()) + "' is not an empty directory");
        }
    }

    private HttpResponse createResponse(ContentRequest request) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("prepared", request.getUrlBase("/prepared"));
        return new SlimeJsonResponse(slime);
    }
}

