/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Value;
import com.yahoo.net.HostName;
import java.time.Duration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDistributionImpl
implements FileDistribution,
RequestWaiter {
    private static final Logger log = Logger.getLogger(FileDistributionImpl.class.getName());
    private static final Duration rpcTimeout = Duration.ofSeconds(11L);
    private final Supervisor supervisor;

    public FileDistributionImpl(Supervisor supervisor) {
        this.supervisor = supervisor;
    }

    public void triggerDownload(String hostName, int port, Set<FileReference> fileReferences) {
        Target target = this.supervisor.connect(new Spec(hostName, port));
        Request request = new Request("filedistribution.triggerDownload");
        request.setContext((Object)target);
        request.parameters().add((Value)new StringArray((String[])fileReferences.stream().map(FileReference::value).toArray(String[]::new)));
        request.parameters().add((Value)new StringValue(new Spec(HostName.getLocalhost(), 19070).toString()));
        log.log(Level.FINE, () -> "Executing " + request.methodName() + " against " + String.valueOf(target) + ": " + String.valueOf(fileReferences));
        target.invokeAsync(request, rpcTimeout, (RequestWaiter)this);
    }

    public void handleRequestDone(Request req) {
        Target target = (Target)req.getContext();
        if (req.isError()) {
            log.log(Level.FINE, () -> req.methodName() + " failed for " + String.valueOf(target) + ": " + req.errorCode() + " (" + req.errorMessage() + ")");
        }
        if (target != null) {
            target.close();
        }
    }
}

