/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2.response;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.metrics.SearchNodeMetricsAggregator;
import java.util.Map;

public class SearchNodeMetricsResponse
extends SlimeJsonResponse {
    public SearchNodeMetricsResponse(ApplicationId applicationId, Map<String, SearchNodeMetricsAggregator> aggregatedMetrics) {
        Cursor application = this.slime.setObject();
        application.setString("applicationId", applicationId.serializedForm());
        Cursor clusters = application.setArray("clusters");
        for (Map.Entry<String, SearchNodeMetricsAggregator> entry : aggregatedMetrics.entrySet()) {
            Cursor cluster = clusters.addObject();
            cluster.setString("clusterId", entry.getKey());
            SearchNodeMetricsAggregator aggregator = entry.getValue();
            Cursor metrics = cluster.setObject("metrics");
            metrics.setDouble("documentsActiveCount", aggregator.aggregateDocumentActiveCount().doubleValue());
            metrics.setDouble("documentsReadyCount", aggregator.aggregateDocumentReadyCount().doubleValue());
            metrics.setDouble("documentsTotalCount", aggregator.aggregateDocumentTotalCount().doubleValue());
            metrics.setDouble("documentDiskUsage", aggregator.aggregateDocumentDiskUsage().doubleValue());
            metrics.setDouble("resourceDiskUsageAverage", aggregator.aggregateResourceDiskUsageAverage().doubleValue());
            metrics.setDouble("resourceMemoryUsageAverage", aggregator.aggregateResourceMemoryUsageAverage().doubleValue());
        }
    }
}

