/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2.response;

import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ClusterReindexing;
import com.yahoo.vespa.config.server.http.JSONResponse;
import java.time.Instant;
import java.util.Map;
import java.util.Set;

public class ReindexingResponse
extends JSONResponse {
    public ReindexingResponse(Map<String, Set<String>> documentTypes, ApplicationReindexing reindexing, Map<String, ClusterReindexing> clusters) {
        super(200);
        this.object.setBool("enabled", reindexing.enabled());
        Cursor clustersObject = this.object.setObject("clusters");
        documentTypes.forEach((cluster, types) -> {
            Cursor clusterObject = clustersObject.setObject(cluster);
            Cursor pendingObject = clusterObject.setObject("pending");
            Cursor readyObject = clusterObject.setObject("ready");
            for (String type : types) {
                Cursor statusObject = readyObject.setObject(type);
                Instant readyAt = Instant.EPOCH;
                ClusterReindexing.State state = null;
                if (reindexing.clusters().containsKey(cluster)) {
                    if (reindexing.clusters().get(cluster).pending().containsKey(type)) {
                        pendingObject.setLong(type, reindexing.clusters().get(cluster).pending().get(type).longValue());
                        state = ClusterReindexing.State.PENDING;
                    }
                    if (reindexing.clusters().get(cluster).ready().containsKey(type)) {
                        ApplicationReindexing.Status readyStatus = reindexing.clusters().get(cluster).ready().get(type);
                        readyAt = readyStatus.ready();
                        statusObject.setLong("readyMillis", readyStatus.ready().toEpochMilli());
                        statusObject.setDouble("speed", readyStatus.speed());
                        statusObject.setString("cause", readyStatus.cause());
                    }
                }
                if (clusters.containsKey(cluster) && ((ClusterReindexing)clusters.get(cluster)).documentTypeStatus().containsKey(type)) {
                    ClusterReindexing.Status status = ((ClusterReindexing)clusters.get(cluster)).documentTypeStatus().get(type);
                    statusObject.setLong("startedMillis", status.startedAt().toEpochMilli());
                    status.endedAt().ifPresent(endedAt -> statusObject.setLong("endedMillis", endedAt.toEpochMilli()));
                    if (status.startedAt().isAfter(readyAt) && status.state().isPresent()) {
                        state = status.state().get();
                    }
                    status.message().ifPresent(message -> statusObject.setString("message", message));
                    status.progress().ifPresent(progress -> statusObject.setDouble("progress", progress.doubleValue()));
                }
                if (readyAt != Instant.EPOCH && state == null) {
                    state = ClusterReindexing.State.PENDING;
                }
                if (state == null) continue;
                statusObject.setString("state", state.asString());
            }
        });
    }
}

