/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.metrics.SearchNodeMetricsAggregator;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.Timeout;

public class ClusterSearchNodeMetricsRetriever {
    private static final Logger log = Logger.getLogger(ClusterSearchNodeMetricsRetriever.class.getName());
    private static final CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().connectTimeout(Timeout.ofSeconds((long)10L)).apacheBuilder().setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofSeconds((long)10L)).build()).build();

    public Map<String, SearchNodeMetricsAggregator> requestMetricsGroupedByCluster(Collection<URI> hosts) {
        ConcurrentHashMap<String, SearchNodeMetricsAggregator> clusterMetricsMap = new ConcurrentHashMap<String, SearchNodeMetricsAggregator>();
        for (URI uri : hosts) {
            ClusterSearchNodeMetricsRetriever.addMetricsFromHost(uri, clusterMetricsMap);
        }
        return clusterMetricsMap;
    }

    private static void addMetricsFromHost(URI hostURI, Map<String, SearchNodeMetricsAggregator> clusterMetricsMap) {
        Slime hostResponseBody = ClusterSearchNodeMetricsRetriever.doMetricsRequest(hostURI);
        Cursor error = hostResponseBody.get().field("error_message");
        if (error.valid()) {
            log.info("Failed to retrieve metrics from " + String.valueOf(hostURI) + ": " + error.asString());
        }
        Cursor nodes = hostResponseBody.get().field("nodes");
        nodes.traverse((i, nodesInspector) -> ClusterSearchNodeMetricsRetriever.parseNode(nodesInspector, clusterMetricsMap));
    }

    private static void parseNode(Inspector node, Map<String, SearchNodeMetricsAggregator> clusterMetricsMap) {
        String nodeRole = node.field("role").asString();
        if (nodeRole.contains("content")) {
            SearchNodeMetricsAggregator aggregator = new SearchNodeMetricsAggregator();
            clusterMetricsMap.put(nodeRole, aggregator);
            node.field("services").traverse((i, servicesInspector) -> ClusterSearchNodeMetricsRetriever.addServicesToAggregator(servicesInspector, aggregator));
        }
    }

    private static void addServicesToAggregator(Inspector services, SearchNodeMetricsAggregator aggregator) {
        services.field("metrics").traverse((i, metricsInspector) -> ClusterSearchNodeMetricsRetriever.addMetricsToAggregator(metricsInspector, aggregator));
    }

    private static void addMetricsToAggregator(Inspector metrics, SearchNodeMetricsAggregator aggregator) {
        aggregator.addAll(metrics.field("values"));
    }

    private static Slime doMetricsRequest(URI hostURI) {
        Slime slime;
        block8: {
            HttpGet get = new HttpGet(hostURI);
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)get);
            try {
                byte[] body = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                slime = SlimeUtils.jsonToSlime((byte[])body);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.info("Was unable to fetch metrics from " + String.valueOf(hostURI) + " : " + Exceptions.toMessageString((Throwable)e));
                    return new Slime();
                }
            }
            response.close();
        }
        return slime;
    }
}

