/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.ApplicationFileManager;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionImpl;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;

public class FileDistributionFactory
implements AutoCloseable {
    protected final ConfigserverConfig configserverConfig;
    protected final FileDirectory fileDirectory;
    private final FlagSource flagSource;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution"));

    @Inject
    public FileDistributionFactory(ConfigserverConfig configserverConfig, FileDirectory fileDirectory, FlagSource flagSource) {
        this.configserverConfig = configserverConfig;
        this.fileDirectory = fileDirectory;
        this.flagSource = flagSource;
    }

    public FileRegistry createFileRegistry(File applicationPackage) {
        return new FileDBRegistry(this.createFileManager(applicationPackage));
    }

    public FileDistribution createFileDistribution() {
        return new FileDistributionImpl(this.supervisor, this.flagSource);
    }

    public AddFileInterface createFileManager(File applicationDir) {
        return new ApplicationFileManager(applicationDir, this.fileDirectory, this.configserverConfig.hostedVespa());
    }

    public FileDirectory fileDirectory() {
        return this.fileDirectory;
    }

    @Override
    public void close() {
        this.supervisor.transport().shutdown().join();
    }
}

