/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.OnnxModelCost;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.api.TenantVault;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.SharedHosts;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.DoubleFlag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.IntFlag;
import com.yahoo.vespa.flags.JacksonFlag;
import com.yahoo.vespa.flags.ListFlag;
import com.yahoo.vespa.flags.LongFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import com.yahoo.vespa.flags.StringFlag;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final ExecutorService executor;
    private final HostProvisioner hostProvisioner;
    private final Provisioned provisioned;
    private final Optional<? extends Reindexing> reindexing;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final OnnxModelCost onnxModelCost;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, ExecutorService executor, Optional<? extends Reindexing> reindexing, HostProvisioner hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, OnnxModelCost onnxModelCost, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.executor = executor;
        this.reindexing = reindexing;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
        this.onnxModelCost = onnxModelCost;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public HostProvisioner getHostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Optional<? extends Reindexing> reindexing() {
        return this.reindexing;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public OnnxModelCost onnxModelCost() {
        return this.onnxModelCost;
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ModelContext.FeatureFlags featureFlags;
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String tenantSecretDomain;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final Optional<AthenzDomain> athenzDomain;
        private final Quota quota;
        private final List<TenantVault> tenantVaults;
        private final List<TenantSecretStore> tenantSecretStores;
        private final StringFlag jvmGCOptionsFlag;
        private final boolean allowDisableMtls;
        private final List<X509Certificate> operatorCertificates;
        private final List<String> tlsCiphersOverride;
        private final List<String> environmentVariables;
        private final Optional<CloudAccount> cloudAccount;
        private final List<DataplaneToken> dataplaneTokens;
        private final boolean allowUserFilters;
        private final Duration endpointConnectionTtl;
        private final List<String> requestPrefixForLoggingContent;

        public Properties(ApplicationId applicationId, Version modelVersion, ConfigserverConfig configserverConfig, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain, Optional<Quota> maybeQuota, List<TenantVault> tenantVaults, List<TenantSecretStore> tenantSecretStores, List<X509Certificate> operatorCertificates, Optional<CloudAccount> cloudAccount, List<DataplaneToken> dataplaneTokens) {
            this.featureFlags = new FeatureFlags(flagSource, applicationId, modelVersion);
            this.applicationId = applicationId;
            this.multitenant = configserverConfig.multitenant() || configserverConfig.hostedVespa() || Boolean.getBoolean("multitenant");
            this.configServerSpecs = ConfigServerSpec.fromConfig(configserverConfig);
            this.loadBalancerName = configserverConfig.loadBalancerAddress().isEmpty() ? null : HostName.of((String)configserverConfig.loadBalancerAddress());
            this.ztsUrl = configserverConfig.ztsUrl() != null ? URI.create(configserverConfig.ztsUrl()) : null;
            this.tenantSecretDomain = configserverConfig.tenantSecretDomain();
            this.athenzDnsSuffix = configserverConfig.athenzDnsSuffix();
            this.hostedVespa = configserverConfig.hostedVespa();
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.athenzDomain = athenzDomain;
            this.quota = maybeQuota.orElseGet(Quota::unlimited);
            this.tenantVaults = tenantVaults;
            this.tenantSecretStores = tenantSecretStores;
            this.jvmGCOptionsFlag = (StringFlag)((StringFlag)((StringFlag)PermanentFlags.JVM_GC_OPTIONS.bindTo(flagSource)).with(Dimension.INSTANCE_ID, applicationId.serializedForm())).with(Dimension.APPLICATION, applicationId.toSerializedFormWithoutInstance());
            this.allowDisableMtls = ((BooleanFlag)((BooleanFlag)PermanentFlags.ALLOW_DISABLE_MTLS.bindTo(flagSource)).with(applicationId)).value();
            this.operatorCertificates = operatorCertificates;
            this.tlsCiphersOverride = ((ListFlag)((ListFlag)PermanentFlags.TLS_CIPHERS_OVERRIDE.bindTo(flagSource)).with(applicationId)).value();
            this.environmentVariables = ((ListFlag)((ListFlag)PermanentFlags.ENVIRONMENT_VARIABLES.bindTo(flagSource)).with(applicationId)).value();
            this.cloudAccount = cloudAccount;
            this.allowUserFilters = ((BooleanFlag)((BooleanFlag)PermanentFlags.ALLOW_USER_FILTERS.bindTo(flagSource)).with(applicationId)).value();
            this.endpointConnectionTtl = Duration.ofSeconds(((IntFlag)((IntFlag)PermanentFlags.ENDPOINT_CONNECTION_TTL.bindTo(flagSource)).with(applicationId)).value());
            this.dataplaneTokens = dataplaneTokens;
            this.requestPrefixForLoggingContent = ((ListFlag)((ListFlag)PermanentFlags.LOG_REQUEST_CONTENT.bindTo(flagSource)).with(applicationId)).value();
        }

        public ModelContext.FeatureFlags featureFlags() {
            return this.featureFlags;
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public AthenzDomain tenantSecretDomain() {
            if (this.tenantSecretDomain.isEmpty()) {
                throw new IllegalArgumentException("Tenant secret domain is not set for zone " + this.zone);
            }
            return AthenzDomain.from((String)this.tenantSecretDomain);
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }

        public Quota quota() {
            return this.quota;
        }

        public List<TenantVault> tenantVaults() {
            return this.tenantVaults;
        }

        public List<TenantSecretStore> tenantSecretStores() {
            return this.tenantSecretStores;
        }

        public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
            return this.flagValueForClusterType(this.jvmGCOptionsFlag, clusterType);
        }

        public boolean allowDisableMtls() {
            return this.allowDisableMtls;
        }

        public List<X509Certificate> operatorCertificates() {
            return this.operatorCertificates;
        }

        public List<String> tlsCiphersOverride() {
            return this.tlsCiphersOverride;
        }

        public String flagValueForClusterType(StringFlag flag, Optional<ClusterSpec.Type> clusterType) {
            return clusterType.map(type -> (StringFlag)flag.with(Dimension.CLUSTER_TYPE, type.name())).orElse(flag).value();
        }

        public List<String> environmentVariables() {
            return this.environmentVariables;
        }

        public Optional<CloudAccount> cloudAccount() {
            return this.cloudAccount;
        }

        public List<DataplaneToken> dataplaneTokens() {
            return this.dataplaneTokens;
        }

        public boolean allowUserFilters() {
            return this.allowUserFilters;
        }

        public Duration endpointConnectionTtl() {
            return this.endpointConnectionTtl;
        }

        public List<String> requestPrefixForLoggingContent() {
            return this.requestPrefixForLoggingContent;
        }
    }

    public static class FeatureFlags
    implements ModelContext.FeatureFlags {
        private final double queryDispatchWarmup;
        private final String responseSequencer;
        private final int numResponseThreads;
        private final boolean useAsyncMessageHandlingOnSchedule;
        private final double feedConcurrency;
        private final double feedNiceness;
        private final List<String> allowedAthenzProxyIdentities;
        private final int maxActivationInhibitedOutOfSyncGroups;
        private final double resourceLimitDisk;
        private final double resourceLimitMemory;
        private final double resourceLimitLowWatermarkDifference;
        private final double minNodeRatioPerGroup;
        private final boolean containerDumpHeapOnShutdownTimeout;
        private final int maxUnCommittedMemory;
        private final String searchMmapAdvise;
        private final boolean forwardIssuesAsErrors;
        private final boolean useV8GeoPositions;
        private final List<String> ignoredHttpUserAgents;
        private final String logFileCompressionAlgorithm;
        private final int mbus_network_threads;
        private final int mbus_java_num_targets;
        private final int mbus_java_events_before_wakeup;
        private final int mbus_cpp_num_targets;
        private final int mbus_cpp_events_before_wakeup;
        private final int rpc_num_targets;
        private final int rpc_events_before_wakeup;
        private final int heapPercentage;
        private final String summaryDecodePolicy;
        private final boolean sortBlueprintsByCost;
        private final boolean alwaysMarkPhraseExpensive;
        private final int contentLayerMetadataFeatureLevel;
        private final String unknownConfigDefinition;
        private final int searchHandlerThreadpool;
        private final int persistenceThreadMaxFeedOpBatchSize;
        private final boolean logserverOtelCol;
        private final SharedHosts sharedHosts;
        private final NodeResources.Architecture adminClusterArchitecture;
        private final double logserverNodeMemory;
        private final double clusterControllerNodeMemory;
        private final boolean symmetricPutAndActivateReplicaSelection;
        private final boolean enforceStrictlyIncreasingClusterStateVersions;
        private final boolean useLegacyWandQueryParsing;
        private final boolean forwardAllLogLevels;
        private final long zookeeperPreAllocSize;
        private final int documentV1QueueSize;

        public FeatureFlags(FlagSource source, ApplicationId appId, Version version) {
            this.responseSequencer = ((StringFlag)((StringFlag)((StringFlag)Flags.RESPONSE_SEQUENCER_TYPE.bindTo(source)).with(appId)).with(version)).value();
            this.numResponseThreads = ((IntFlag)((IntFlag)((IntFlag)Flags.RESPONSE_NUM_THREADS.bindTo(source)).with(appId)).with(version)).value();
            this.useAsyncMessageHandlingOnSchedule = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE.bindTo(source)).with(appId)).with(version)).value();
            this.feedConcurrency = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.FEED_CONCURRENCY.bindTo(source)).with(appId)).with(version)).value();
            this.feedNiceness = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.FEED_NICENESS.bindTo(source)).with(appId)).with(version)).value();
            this.mbus_network_threads = ((IntFlag)((IntFlag)((IntFlag)Flags.MBUS_NUM_NETWORK_THREADS.bindTo(source)).with(appId)).with(version)).value();
            this.allowedAthenzProxyIdentities = ((ListFlag)((ListFlag)((ListFlag)PermanentFlags.ALLOWED_ATHENZ_PROXY_IDENTITIES.bindTo(source)).with(appId)).with(version)).value();
            this.maxActivationInhibitedOutOfSyncGroups = ((IntFlag)((IntFlag)((IntFlag)Flags.MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS.bindTo(source)).with(appId)).with(version)).value();
            this.resourceLimitDisk = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.RESOURCE_LIMIT_DISK.bindTo(source)).with(appId)).with(version)).value();
            this.resourceLimitMemory = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.RESOURCE_LIMIT_MEMORY.bindTo(source)).with(appId)).with(version)).value();
            this.resourceLimitLowWatermarkDifference = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.RESOURCE_LIMIT_LOW_WATERMARK_DIFFERENCE.bindTo(source)).with(appId)).with(version)).value();
            this.minNodeRatioPerGroup = ((DoubleFlag)((DoubleFlag)((DoubleFlag)Flags.MIN_NODE_RATIO_PER_GROUP.bindTo(source)).with(appId)).with(version)).value();
            this.containerDumpHeapOnShutdownTimeout = ((BooleanFlag)((BooleanFlag)((BooleanFlag)PermanentFlags.CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT.bindTo(source)).with(appId)).with(version)).value();
            this.maxUnCommittedMemory = ((IntFlag)((IntFlag)((IntFlag)PermanentFlags.MAX_UNCOMMITTED_MEMORY.bindTo(source)).with(appId)).with(version)).value();
            this.searchMmapAdvise = ((StringFlag)((StringFlag)((StringFlag)Flags.SEARCH_MMAP_ADVISE.bindTo(source)).with(appId)).with(version)).value();
            this.forwardIssuesAsErrors = ((BooleanFlag)((BooleanFlag)((BooleanFlag)PermanentFlags.FORWARD_ISSUES_AS_ERRORS.bindTo(source)).with(appId)).with(version)).value();
            this.useV8GeoPositions = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.USE_V8_GEO_POSITIONS.bindTo(source)).with(appId)).with(version)).value();
            this.ignoredHttpUserAgents = ((ListFlag)((ListFlag)((ListFlag)PermanentFlags.IGNORED_HTTP_USER_AGENTS.bindTo(source)).with(appId)).with(version)).value();
            this.logFileCompressionAlgorithm = ((StringFlag)((StringFlag)((StringFlag)Flags.LOG_FILE_COMPRESSION_ALGORITHM.bindTo(source)).with(appId)).with(version)).value();
            this.mbus_java_num_targets = ((IntFlag)((IntFlag)((IntFlag)Flags.MBUS_JAVA_NUM_TARGETS.bindTo(source)).with(appId)).with(version)).value();
            this.mbus_java_events_before_wakeup = ((IntFlag)((IntFlag)((IntFlag)Flags.MBUS_JAVA_EVENTS_BEFORE_WAKEUP.bindTo(source)).with(appId)).with(version)).value();
            this.mbus_cpp_num_targets = ((IntFlag)((IntFlag)((IntFlag)Flags.MBUS_CPP_NUM_TARGETS.bindTo(source)).with(appId)).with(version)).value();
            this.mbus_cpp_events_before_wakeup = ((IntFlag)((IntFlag)((IntFlag)Flags.MBUS_CPP_EVENTS_BEFORE_WAKEUP.bindTo(source)).with(appId)).with(version)).value();
            this.rpc_num_targets = ((IntFlag)((IntFlag)((IntFlag)Flags.RPC_NUM_TARGETS.bindTo(source)).with(appId)).with(version)).value();
            this.rpc_events_before_wakeup = ((IntFlag)((IntFlag)((IntFlag)Flags.RPC_EVENTS_BEFORE_WAKEUP.bindTo(source)).with(appId)).with(version)).value();
            this.queryDispatchWarmup = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.QUERY_DISPATCH_WARMUP.bindTo(source)).with(appId)).with(version)).value();
            this.heapPercentage = ((IntFlag)((IntFlag)((IntFlag)PermanentFlags.HEAP_SIZE_PERCENTAGE.bindTo(source)).with(appId)).with(version)).value();
            this.summaryDecodePolicy = ((StringFlag)((StringFlag)((StringFlag)Flags.SUMMARY_DECODE_POLICY.bindTo(source)).with(appId)).with(version)).value();
            this.contentLayerMetadataFeatureLevel = ((IntFlag)((IntFlag)((IntFlag)Flags.CONTENT_LAYER_METADATA_FEATURE_LEVEL.bindTo(source)).with(appId)).with(version)).value();
            this.unknownConfigDefinition = ((StringFlag)((StringFlag)((StringFlag)PermanentFlags.UNKNOWN_CONFIG_DEFINITION.bindTo(source)).with(appId)).with(version)).value();
            this.searchHandlerThreadpool = ((IntFlag)((IntFlag)((IntFlag)Flags.SEARCH_HANDLER_THREADPOOL.bindTo(source)).with(appId)).with(version)).value();
            this.alwaysMarkPhraseExpensive = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.ALWAYS_MARK_PHRASE_EXPENSIVE.bindTo(source)).with(appId)).with(version)).value();
            this.sortBlueprintsByCost = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.SORT_BLUEPRINTS_BY_COST.bindTo(source)).with(appId)).with(version)).value();
            this.persistenceThreadMaxFeedOpBatchSize = ((IntFlag)((IntFlag)((IntFlag)Flags.PERSISTENCE_THREAD_MAX_FEED_OP_BATCH_SIZE.bindTo(source)).with(appId)).with(version)).value();
            this.logserverOtelCol = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.LOGSERVER_OTELCOL_AGENT.bindTo(source)).with(appId)).with(version)).value();
            this.sharedHosts = (SharedHosts)((JacksonFlag)((JacksonFlag)((JacksonFlag)PermanentFlags.SHARED_HOST.bindTo(source)).with(appId)).with(version)).value();
            this.adminClusterArchitecture = NodeResources.Architecture.valueOf((String)((StringFlag)((StringFlag)((StringFlag)PermanentFlags.ADMIN_CLUSTER_NODE_ARCHITECTURE.bindTo(source)).with(appId)).with(version)).value());
            this.logserverNodeMemory = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.LOGSERVER_NODE_MEMORY.bindTo(source)).with(appId)).with(version)).value();
            this.clusterControllerNodeMemory = ((DoubleFlag)((DoubleFlag)((DoubleFlag)PermanentFlags.CLUSTER_CONTROLLER_NODE_MEMORY.bindTo(source)).with(appId)).with(version)).value();
            this.symmetricPutAndActivateReplicaSelection = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.SYMMETRIC_PUT_AND_ACTIVATE_REPLICA_SELECTION.bindTo(source)).with(appId)).with(version)).value();
            this.enforceStrictlyIncreasingClusterStateVersions = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.ENFORCE_STRICTLY_INCREASING_CLUSTER_STATE_VERSIONS.bindTo(source)).with(appId)).with(version)).value();
            this.useLegacyWandQueryParsing = ((BooleanFlag)((BooleanFlag)((BooleanFlag)Flags.USE_LEGACY_WAND_QUERY_PARSING.bindTo(source)).with(appId)).with(version)).value();
            this.forwardAllLogLevels = ((BooleanFlag)((BooleanFlag)((BooleanFlag)PermanentFlags.FORWARD_ALL_LOG_LEVELS.bindTo(source)).with(appId)).with(version)).value();
            this.zookeeperPreAllocSize = ((LongFlag)Flags.ZOOKEEPER_PRE_ALLOC_SIZE_KIB.bindTo(source)).value();
            this.documentV1QueueSize = ((IntFlag)((IntFlag)((IntFlag)Flags.DOCUMENT_V1_QUEUE_SIZE.bindTo(source)).with(appId)).with(version)).value();
        }

        public int heapSizePercentage() {
            return this.heapPercentage;
        }

        public double queryDispatchWarmup() {
            return this.queryDispatchWarmup;
        }

        public String summaryDecodePolicy() {
            return this.summaryDecodePolicy;
        }

        public String responseSequencerType() {
            return this.responseSequencer;
        }

        public int defaultNumResponseThreads() {
            return this.numResponseThreads;
        }

        public boolean useAsyncMessageHandlingOnSchedule() {
            return this.useAsyncMessageHandlingOnSchedule;
        }

        public double feedConcurrency() {
            return this.feedConcurrency;
        }

        public double feedNiceness() {
            return this.feedNiceness;
        }

        public int mbusNetworkThreads() {
            return this.mbus_network_threads;
        }

        public List<String> allowedAthenzProxyIdentities() {
            return this.allowedAthenzProxyIdentities;
        }

        public int maxActivationInhibitedOutOfSyncGroups() {
            return this.maxActivationInhibitedOutOfSyncGroups;
        }

        public double resourceLimitDisk() {
            return this.resourceLimitDisk;
        }

        public double resourceLimitMemory() {
            return this.resourceLimitMemory;
        }

        public double resourceLimitLowWatermarkDifference() {
            return this.resourceLimitLowWatermarkDifference;
        }

        public double minNodeRatioPerGroup() {
            return this.minNodeRatioPerGroup;
        }

        public boolean containerDumpHeapOnShutdownTimeout() {
            return this.containerDumpHeapOnShutdownTimeout;
        }

        public int maxUnCommittedMemory() {
            return this.maxUnCommittedMemory;
        }

        public String searchMmapAdvise() {
            return this.searchMmapAdvise;
        }

        public boolean forwardIssuesAsErrors() {
            return this.forwardIssuesAsErrors;
        }

        public boolean useV8GeoPositions() {
            return this.useV8GeoPositions;
        }

        public List<String> ignoredHttpUserAgents() {
            return this.ignoredHttpUserAgents;
        }

        public int mbusJavaRpcNumTargets() {
            return this.mbus_java_num_targets;
        }

        public int mbusJavaEventsBeforeWakeup() {
            return this.mbus_java_events_before_wakeup;
        }

        public int mbusCppRpcNumTargets() {
            return this.mbus_cpp_num_targets;
        }

        public int mbusCppEventsBeforeWakeup() {
            return this.mbus_cpp_events_before_wakeup;
        }

        public int rpcNumTargets() {
            return this.rpc_num_targets;
        }

        public int rpcEventsBeforeWakeup() {
            return this.rpc_events_before_wakeup;
        }

        public String logFileCompressionAlgorithm(String defVal) {
            String fflag = this.logFileCompressionAlgorithm;
            if (fflag != null && !fflag.isEmpty()) {
                return fflag;
            }
            return defVal;
        }

        public boolean alwaysMarkPhraseExpensive() {
            return this.alwaysMarkPhraseExpensive;
        }

        public int contentLayerMetadataFeatureLevel() {
            return this.contentLayerMetadataFeatureLevel;
        }

        public String unknownConfigDefinition() {
            return this.unknownConfigDefinition;
        }

        public int searchHandlerThreadpool() {
            return this.searchHandlerThreadpool;
        }

        public boolean sortBlueprintsByCost() {
            return this.sortBlueprintsByCost;
        }

        public int persistenceThreadMaxFeedOpBatchSize() {
            return this.persistenceThreadMaxFeedOpBatchSize;
        }

        public boolean logserverOtelCol() {
            return this.logserverOtelCol;
        }

        public SharedHosts sharedHosts() {
            return this.sharedHosts;
        }

        public NodeResources.Architecture adminClusterArchitecture() {
            return this.adminClusterArchitecture;
        }

        public double logserverNodeMemory() {
            return this.logserverNodeMemory;
        }

        public double clusterControllerNodeMemory() {
            return this.clusterControllerNodeMemory;
        }

        public boolean symmetricPutAndActivateReplicaSelection() {
            return this.symmetricPutAndActivateReplicaSelection;
        }

        public boolean enforceStrictlyIncreasingClusterStateVersions() {
            return this.enforceStrictlyIncreasingClusterStateVersions;
        }

        public boolean useLegacyWandQueryParsing() {
            return this.useLegacyWandQueryParsing;
        }

        public boolean forwardAllLogLevels() {
            return this.forwardAllLogLevels;
        }

        public long zookeeperPreAllocSize() {
            return this.zookeeperPreAllocSize;
        }

        public int documentV1QueueSize() {
            return this.documentV1QueueSize;
        }
    }
}

