/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.recipes.CuratorCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InitializedCounter {
    private static final Logger log = Logger.getLogger(InitializedCounter.class.getName());
    final CuratorCounter counter;
    private final Path sessionsDirPath;

    InitializedCounter(Curator curator, Path counterPath, Path sessionsDirPath) {
        this.sessionsDirPath = sessionsDirPath;
        this.counter = new CuratorCounter(curator, counterPath);
        this.initializeCounterValue(InitializedCounter.getLatestSessionId(curator, sessionsDirPath));
    }

    private void initializeCounterValue(Long latestSessionId) {
        log.log(Level.FINE, () -> "path=" + this.sessionsDirPath + ", current=" + latestSessionId);
        if (latestSessionId != null) {
            this.counter.initialize(latestSessionId.longValue());
        } else {
            this.counter.initialize(1L);
        }
    }

    private static boolean applicationExists(Curator curator, Path appsPath) {
        return curator.exists(appsPath);
    }

    private static Long getLatestSessionId(Curator curator, Path appsPath) {
        if (!InitializedCounter.applicationExists(curator, appsPath)) {
            return null;
        }
        Long newestGeneration = null;
        try {
            if (!InitializedCounter.getDeployedApplicationGenerations(curator, appsPath).isEmpty()) {
                newestGeneration = Collections.max(InitializedCounter.getDeployedApplicationGenerations(curator, appsPath));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not get newest application generation from Zookeeper");
        }
        return newestGeneration;
    }

    private static List<Long> getDeployedApplicationGenerations(Curator curator, Path appsPath) {
        ArrayList<Long> generations = new ArrayList<Long>();
        try {
            List stringGenerations = curator.getChildren(appsPath);
            if (stringGenerations != null && !stringGenerations.isEmpty()) {
                for (String s : stringGenerations) {
                    generations.add(Long.parseLong(s));
                }
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Could not get application generations from Zookeeper");
        }
        return generations;
    }
}

