/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.serialization.AllocatedHostsSerializer;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ZooKeeperDeployer {
    private final Client client;

    public ZooKeeperDeployer(Curator curator, DeployLogger logger, ApplicationId applicationId, long sessionId) {
        Path sessionPath = SessionZooKeeperClient.getSessionPath(applicationId.tenant(), sessionId);
        this.client = new Client(curator, logger, sessionPath);
    }

    public void deploy(ApplicationPackage applicationPackage, Map<Version, FileRegistry> fileRegistryMap, AllocatedHosts allocatedHosts) throws IOException {
        this.client.initialize();
        this.client.writeApplicationPackage(applicationPackage);
        this.client.write(fileRegistryMap);
        this.client.write(allocatedHosts);
    }

    public void cleanup() {
        this.client.cleanupZooKeeper();
    }

    public static class Client {
        private final Curator curator;
        private final DeployLogger logger;
        private final Path sessionPath;
        private static final ApplicationFile.PathFilter xmlFilter = path -> path.getName().endsWith(".xml");

        public Client(Curator curator, DeployLogger logger, Path sessionPath) {
            this.curator = curator;
            this.logger = logger;
            this.sessionPath = sessionPath;
        }

        void initialize() {
            this.curator.create(this.sessionPath);
            for (String subPath : List.of("/defconfigs", "/userdefconfigs", "/userapp", "fileregistry")) {
                this.curator.create(this.getZooKeeperAppPath().append(subPath.replaceFirst("/", "")));
            }
        }

        void writeApplicationPackage(ApplicationPackage app) {
            try {
                this.writeUserDefs(app);
                this.writeSomeOf(app);
                this.writeSchemas(app);
                this.writeUserIncludeDirs(app, app.getUserIncludeDirs());
                this.writeMetadata(app.getMetaData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to write vespa model to config server(s) " + System.getProperty("configsources") + "\nPlease ensure that config server is started and check the vespa log for configserver errors. ", e);
            }
        }

        private void writeSchemas(ApplicationPackage app) throws IOException {
            Collection schemas = app.getSchemas();
            if (schemas.isEmpty()) {
                return;
            }
            Path zkPath = this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.SCHEMAS_DIR);
            this.curator.create(zkPath);
            this.writeDir(app.getFile(ApplicationPackage.SEARCH_DEFINITIONS_DIR), zkPath);
            this.writeDir(app.getFile(ApplicationPackage.SCHEMAS_DIR), zkPath);
            for (NamedReader sd : schemas) {
                this.curator.set(zkPath.append(sd.getName()), Utf8.toBytes((String)IOUtils.readAll((Reader)sd.getReader())));
                sd.getReader().close();
            }
        }

        private void writeSomeOf(ApplicationPackage app) throws IOException {
            this.writeFile(app.getFile(Path.fromString((String)"services.xml")), this.getZooKeeperAppPath("/userapp"));
            this.writeFile(app.getFile(Path.fromString((String)"hosts.xml")), this.getZooKeeperAppPath("/userapp"));
            this.writeFile(app.getFile(Path.fromString((String)ApplicationPackage.DEPLOYMENT_FILE.getName())), this.getZooKeeperAppPath("/userapp"));
            this.writeFile(app.getFile(Path.fromString((String)ApplicationPackage.VALIDATION_OVERRIDES.getName())), this.getZooKeeperAppPath("/userapp"));
            this.writeDir(app.getFile(ApplicationPackage.RULES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.RULES_DIR), path -> path.getName().endsWith(".sr"));
            this.writeDir(app.getFile(ApplicationPackage.QUERY_PROFILES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.QUERY_PROFILES_DIR), xmlFilter);
            this.writeDir(app.getFile(ApplicationPackage.PAGE_TEMPLATES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.PAGE_TEMPLATES_DIR), xmlFilter);
            this.writeDir(app.getFile(Path.fromString((String)"search/chains")), this.getZooKeeperAppPath("/userapp").append("search/chains"), xmlFilter);
            this.writeDir(app.getFile(Path.fromString((String)"docproc/chains")), this.getZooKeeperAppPath("/userapp").append("docproc/chains"), xmlFilter);
            this.writeDir(app.getFile(Path.fromString((String)"routing/tables")), this.getZooKeeperAppPath("/userapp").append("routing/tables"), xmlFilter);
            this.writeDir(app.getFile(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR));
            this.writeDir(app.getFile(ApplicationPackage.SECURITY_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.SECURITY_DIR));
        }

        private void writeDir(ApplicationFile file, Path zooKeeperAppPath) throws IOException {
            this.writeDir(file, zooKeeperAppPath, __ -> true);
        }

        private void writeDir(ApplicationFile dir, Path path, ApplicationFile.PathFilter filenameFilter) throws IOException {
            if (!dir.isDirectory()) {
                return;
            }
            for (ApplicationFile file : this.listFiles(dir, filenameFilter)) {
                String name = file.getPath().getName();
                if (name.startsWith(".")) continue;
                if (file.isDirectory()) {
                    this.curator.create(path.append(name));
                    this.writeDir(file, path.append(name), filenameFilter);
                    continue;
                }
                this.writeFile(file, path);
            }
        }

        private List<ApplicationFile> listFiles(ApplicationFile dir, ApplicationFile.PathFilter filter) {
            List rawList = dir.listFiles();
            ArrayList<ApplicationFile> ret = new ArrayList<ApplicationFile>();
            if (rawList != null) {
                for (ApplicationFile f : rawList) {
                    if (f.isDirectory()) {
                        ret.add(f);
                        continue;
                    }
                    if (!filter.accept(f.getPath())) continue;
                    ret.add(f);
                }
            }
            return ret;
        }

        private void writeFile(ApplicationFile file, Path zkPath) throws IOException {
            if (!file.exists()) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream inputStream = file.createInputStream();){
                inputStream.transferTo(baos);
                baos.flush();
                this.curator.set(zkPath.append(file.getPath().getName()), baos.toByteArray());
            }
        }

        private void writeUserIncludeDirs(ApplicationPackage applicationPackage, List<String> userIncludeDirs) throws IOException {
            for (String userInclude : userIncludeDirs) {
                ApplicationFile dir = applicationPackage.getFile(Path.fromString((String)userInclude));
                List files = dir.listFiles();
                if (files == null || files.isEmpty()) {
                    this.curator.create(this.getZooKeeperAppPath("/userapp/" + userInclude));
                }
                this.writeDir(dir, this.getZooKeeperAppPath("/userapp/" + userInclude), xmlFilter);
            }
        }

        private void writeUserDefs(ApplicationPackage applicationPackage) {
            Map configDefs = applicationPackage.getAllExistingConfigDefs();
            for (Map.Entry entry : configDefs.entrySet()) {
                ConfigDefinitionKey key = (ConfigDefinitionKey)entry.getKey();
                String contents = ((UnparsedConfigDefinition)entry.getValue()).getUnparsedContent();
                this.writeConfigDefinition(key.getName(), key.getNamespace(), this.getZooKeeperAppPath("/userdefconfigs"), contents);
                this.writeConfigDefinition(key.getName(), key.getNamespace(), this.getZooKeeperAppPath("/defconfigs"), contents);
            }
            if (!configDefs.isEmpty()) {
                this.logger.log(Level.FINE, () -> configDefs.size() + " user config definitions");
            }
        }

        private void writeConfigDefinition(String name, String namespace, Path path, String data) {
            this.curator.set(path.append(namespace + "." + name), Utf8.toBytes((String)data));
        }

        private void write(Version vespaVersion, FileRegistry fileRegistry) {
            String exportedRegistry = FileDBRegistry.exportRegistry(fileRegistry);
            this.curator.set(this.getZooKeeperAppPath("fileregistry").append(vespaVersion.toFullString()), Utf8.toBytes((String)exportedRegistry));
        }

        private void writeMetadata(ApplicationMetaData metaData) {
            this.curator.set(this.getZooKeeperAppPath("/meta"), metaData.asJsonBytes());
        }

        void cleanupZooKeeper() {
            try {
                List.of("/defconfigs", "/userdefconfigs", "/userapp").forEach(path -> this.curator.delete(this.getZooKeeperAppPath((String)path)));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Could not clean up in zookeeper: " + Exceptions.toMessageString((Throwable)e));
            }
        }

        private Path getZooKeeperAppPath() {
            return this.getZooKeeperAppPath(null);
        }

        private Path getZooKeeperAppPath(String trailingPath) {
            if (trailingPath == null) {
                return this.sessionPath;
            }
            return this.sessionPath.append(trailingPath);
        }

        public void write(AllocatedHosts hosts) throws IOException {
            this.curator.set(this.sessionPath.append("allocatedHosts"), AllocatedHostsSerializer.toJson((AllocatedHosts)hosts));
        }

        public void write(Map<Version, FileRegistry> fileRegistryMap) {
            for (Map.Entry<Version, FileRegistry> versionFileRegistryEntry : fileRegistryMap.entrySet()) {
                this.write(versionFileRegistryEntry.getKey(), versionFileRegistryEntry.getValue());
            }
        }
    }
}

