/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.StaticConfigDefinitionRepo;
import com.yahoo.vespa.config.server.UserConfigDefinitionRepo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ServerCache {
    private final ConfigDefinitionRepo builtinConfigDefinitions;
    private final ConfigDefinitionRepo userConfigDefinitions;
    private final Map<ConfigCacheKey, PayloadChecksum> checksums = new ConcurrentHashMap<ConfigCacheKey, PayloadChecksum>();
    private final Map<PayloadChecksum, ConfigResponse> checksumToConfig = new ConcurrentHashMap<PayloadChecksum, ConfigResponse>();
    private final Object[] stripedLocks = new Object[113];

    public ServerCache(ConfigDefinitionRepo builtinConfigDefinitions, ConfigDefinitionRepo userConfigDefinitions) {
        this.builtinConfigDefinitions = builtinConfigDefinitions;
        this.userConfigDefinitions = userConfigDefinitions;
        for (int i = 0; i < this.stripedLocks.length; ++i) {
            this.stripedLocks[i] = new Object();
        }
    }

    public ServerCache() {
        this(new StaticConfigDefinitionRepo(), new UserConfigDefinitionRepo());
    }

    private void put(ConfigCacheKey key, ConfigResponse config) {
        PayloadChecksum xxhash64 = config.getPayloadChecksums().getForType(PayloadChecksum.Type.XXHASH64);
        this.checksums.put(key, xxhash64);
        this.checksumToConfig.put(xxhash64, config);
    }

    ConfigResponse get(ConfigCacheKey key) {
        PayloadChecksum xxhash64 = this.checksums.get(key);
        if (xxhash64 == null) {
            return null;
        }
        return this.checksumToConfig.get(xxhash64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigResponse computeIfAbsent(ConfigCacheKey key, Function<ConfigCacheKey, ConfigResponse> mappingFunction) {
        ConfigResponse config = this.get(key);
        if (config != null) {
            return config;
        }
        Object object = this.stripedLocks[Math.abs(key.hashCode() % this.stripedLocks.length)];
        synchronized (object) {
            PayloadChecksum xxhash64 = this.checksums.get(key);
            if (xxhash64 == null) {
                config = mappingFunction.apply(key);
                this.put(key, config);
                return config;
            }
            return this.checksumToConfig.get(xxhash64);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache\n");
        sb.append("builtin defs: ").append(this.builtinConfigDefinitions.getConfigDefinitions().size()).append("\n");
        sb.append("user defs:    ").append(this.userConfigDefinitions.getConfigDefinitions().size()).append("\n");
        sb.append("md5sums:      ").append(this.checksums.size()).append("\n");
        sb.append("md5ToConfig:  ").append(this.checksumToConfig.size()).append("\n");
        return sb.toString();
    }

    public ConfigDefinition getDef(ConfigDefinitionKey defKey) {
        ConfigDefinition def = this.userConfigDefinitions.get(defKey);
        return def != null ? def : (ConfigDefinition)this.builtinConfigDefinitions.getConfigDefinitions().get(defKey);
    }

    public int configElems() {
        return this.checksumToConfig.size();
    }

    public int checkSumElems() {
        return this.checksums.size();
    }
}

