/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.http.HttpURL;
import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.EmptyResponse;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.util.Timeout;

public class LogRetriever {
    private final CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().connectTimeout(Timeout.ofSeconds((long)5L)).socketTimeout(Timeout.ofSeconds((long)45L)).buildClient();

    public HttpResponse getLogs(HttpURL logServerUri, Optional<Instant> deployTime) {
        HttpGet get = new HttpGet(logServerUri.asURI());
        try {
            return new ProxyResponse(this.httpClient.execute((ClassicHttpRequest)get));
        }
        catch (ConnectException | ConnectionRequestTimeoutException e) {
            return new GatewayTimeoutResponse(504);
        }
        catch (IOException e) {
            if (deployTime.isPresent() && Instant.now().isBefore(deployTime.get().plus(Duration.ofMinutes(5L)))) {
                return new EmptyResponse();
            }
            throw new RuntimeException("Failed to get logs from " + logServerUri, e);
        }
    }

    private static class GatewayTimeoutResponse
    extends HttpResponse {
        public GatewayTimeoutResponse(int status) {
            super(status);
        }

        public GatewayTimeoutResponse() {
            this(504);
        }

        public void render(OutputStream outputStream) {
        }
    }
}

