/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.SuperModelController;
import com.yahoo.vespa.config.server.SuperModelManager;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import java.util.Optional;
import java.util.Set;

public class SuperModelRequestHandler
implements RequestHandler {
    private volatile SuperModelController handler;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final ConfigResponseFactory responseFactory;
    private final SuperModelManager superModelManager;
    private volatile boolean enabled = false;

    @Inject
    public SuperModelRequestHandler(ConfigDefinitionRepo configDefinitionRepo, ConfigserverConfig configserverConfig, SuperModelManager superModelManager) {
        this.configDefinitionRepo = configDefinitionRepo;
        this.responseFactory = ConfigResponseFactory.create(configserverConfig);
        this.superModelManager = superModelManager;
        this.updateHandler();
    }

    public synchronized void activateConfig(ApplicationVersions applicationVersions) {
        this.superModelManager.configActivated(applicationVersions);
        this.updateHandler();
    }

    public synchronized void removeApplication(ApplicationId applicationId) {
        this.superModelManager.applicationRemoved(applicationId);
        this.updateHandler();
    }

    private void updateHandler() {
        this.handler = new SuperModelController(this.superModelManager.getSuperModelConfigProvider(), this.configDefinitionRepo, this.superModelManager.getGeneration(), this.responseFactory);
    }

    public SuperModelController getHandler() {
        return this.handler;
    }

    @Override
    public ConfigResponse resolveConfig(ApplicationId appId, GetConfigRequest req, Optional<Version> vespaVersion) {
        return this.handler == null ? null : this.handler.resolveConfig(req);
    }

    @Override
    public Set<ConfigKey<?>> listConfigs(ApplicationId appId, Optional<Version> vespaVersion, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigKey<?>> listNamedConfigs(ApplicationId appId, Optional<Version> vespaVersion, ConfigKey<?> key, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ConfigKey<?>> allConfigsProduced(ApplicationId appId, Optional<Version> vespaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> allConfigIds(ApplicationId appID, Optional<Version> vespaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.enabled && appId.equals((Object)ApplicationId.global());
    }

    @Override
    public ApplicationId resolveApplicationId(String hostName) {
        return ApplicationId.global();
    }

    @Override
    public Set<FileReference> listFileReferences(ApplicationId applicationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compatibleWith(Optional<Version> vespaVersion, ApplicationId application) {
        return true;
    }

    public void enable() {
        this.enabled = true;
        this.superModelManager.markAsComplete();
        this.updateHandler();
    }
}

