/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;

public class ContainerEndpointSerializer {
    private static final String clusterIdField = "clusterId";
    private static final String scopeField = "scope";
    private static final String namesField = "names";
    private static final String weightField = "weight";
    private static final String routingMethodField = "routingMethod";
    private static final String authMethodField = "authMethod";

    private ContainerEndpointSerializer() {
    }

    public static ContainerEndpoint endpointFromSlime(Inspector inspector) {
        String clusterId = inspector.field(clusterIdField).asString();
        String scope = inspector.field(scopeField).asString();
        Inspector namesInspector = inspector.field(namesField);
        OptionalInt weight = SlimeUtils.optionalInteger((Inspector)inspector.field(weightField));
        ApplicationClusterEndpoint.RoutingMethod routingMethod = SlimeUtils.optionalString((Inspector)inspector.field(routingMethodField)).map(ContainerEndpointSerializer::routingMethodFrom).orElse(ApplicationClusterEndpoint.RoutingMethod.sharedLayer4);
        ApplicationClusterEndpoint.AuthMethod authMethod = SlimeUtils.optionalString((Inspector)inspector.field(authMethodField)).map(ContainerEndpointSerializer::authMethodFrom).orElse(ApplicationClusterEndpoint.AuthMethod.mtls);
        if (clusterId.isEmpty()) {
            throw new IllegalStateException("'clusterId' missing on serialized ContainerEndpoint");
        }
        if (scope.isEmpty()) {
            throw new IllegalStateException("'scope' missing on serialized ContainerEndpoint");
        }
        if (!namesInspector.valid()) {
            throw new IllegalStateException("'names' missing on serialized ContainerEndpoint");
        }
        ArrayList names = new ArrayList();
        namesInspector.traverse((idx, nameInspector) -> {
            String containerName = nameInspector.asString();
            names.add(containerName);
        });
        return new ContainerEndpoint(clusterId, ContainerEndpointSerializer.scopeFrom(scope), names, weight, routingMethod, authMethod);
    }

    public static List<ContainerEndpoint> endpointListFromSlime(Slime slime) {
        Cursor inspector = slime.get();
        return ContainerEndpointSerializer.endpointListFromSlime((Inspector)inspector);
    }

    public static List<ContainerEndpoint> endpointListFromSlime(Inspector inspector) {
        ArrayList<ContainerEndpoint> endpoints = new ArrayList<ContainerEndpoint>();
        inspector.traverse((idx, endpointInspector) -> {
            ContainerEndpoint containerEndpoint = ContainerEndpointSerializer.endpointFromSlime(endpointInspector);
            endpoints.add(containerEndpoint);
        });
        return endpoints;
    }

    public static void endpointToSlime(Cursor cursor, ContainerEndpoint endpoint) {
        cursor.setString(clusterIdField, endpoint.clusterId());
        cursor.setString(scopeField, ContainerEndpointSerializer.asString(endpoint.scope()));
        endpoint.weight().ifPresent(w -> cursor.setLong(weightField, (long)w));
        Cursor namesInspector = cursor.setArray(namesField);
        endpoint.names().forEach(arg_0 -> ((Cursor)namesInspector).addString(arg_0));
        cursor.setString(routingMethodField, ContainerEndpointSerializer.asString(endpoint.routingMethod()));
        cursor.setString(authMethodField, ContainerEndpointSerializer.asString(endpoint.authMethod()));
    }

    public static Slime endpointListToSlime(List<ContainerEndpoint> endpoints) {
        Slime slime = new Slime();
        Cursor cursor = slime.setArray();
        endpoints.forEach(endpoint -> {
            Cursor endpointCursor = cursor.addObject();
            ContainerEndpointSerializer.endpointToSlime(endpointCursor, endpoint);
        });
        return slime;
    }

    private static ApplicationClusterEndpoint.RoutingMethod routingMethodFrom(String s) {
        return switch (s) {
            case "shared" -> ApplicationClusterEndpoint.RoutingMethod.shared;
            case "sharedLayer4" -> ApplicationClusterEndpoint.RoutingMethod.sharedLayer4;
            case "exclusive" -> ApplicationClusterEndpoint.RoutingMethod.exclusive;
            default -> throw new IllegalArgumentException("Unknown routing method '" + s + "'");
        };
    }

    private static ApplicationClusterEndpoint.AuthMethod authMethodFrom(String s) {
        return switch (s) {
            case "mtls" -> ApplicationClusterEndpoint.AuthMethod.mtls;
            case "token" -> ApplicationClusterEndpoint.AuthMethod.token;
            default -> throw new IllegalArgumentException("Unknown auth method '" + s + "'");
        };
    }

    private static ApplicationClusterEndpoint.Scope scopeFrom(String s) {
        return switch (s) {
            case "global" -> ApplicationClusterEndpoint.Scope.global;
            case "application" -> ApplicationClusterEndpoint.Scope.application;
            case "zone" -> ApplicationClusterEndpoint.Scope.zone;
            default -> throw new IllegalArgumentException("Unknown scope '" + s + "'");
        };
    }

    private static String asString(ApplicationClusterEndpoint.RoutingMethod routingMethod) {
        return switch (routingMethod) {
            default -> throw new IncompatibleClassChangeError();
            case ApplicationClusterEndpoint.RoutingMethod.shared -> "shared";
            case ApplicationClusterEndpoint.RoutingMethod.sharedLayer4 -> "sharedLayer4";
            case ApplicationClusterEndpoint.RoutingMethod.exclusive -> "exclusive";
        };
    }

    private static String asString(ApplicationClusterEndpoint.AuthMethod authMethod) {
        return switch (authMethod) {
            default -> throw new IncompatibleClassChangeError();
            case ApplicationClusterEndpoint.AuthMethod.mtls -> "mtls";
            case ApplicationClusterEndpoint.AuthMethod.token -> "token";
        };
    }

    private static String asString(ApplicationClusterEndpoint.Scope scope) {
        return switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case ApplicationClusterEndpoint.Scope.global -> "global";
            case ApplicationClusterEndpoint.Scope.application -> "application";
            case ApplicationClusterEndpoint.Scope.zone -> "zone";
        };
    }
}

