/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PendingRestarts {
    private static final PendingRestarts empty = new PendingRestarts(Map.of());
    private final Map<Long, Set<String>> generationsForRestarts;

    public static PendingRestarts empty() {
        return empty;
    }

    PendingRestarts(Map<Long, ? extends Collection<String>> generationsForRestarts) {
        LinkedHashMap builder = new LinkedHashMap();
        generationsForRestarts.forEach((generation, hostnames) -> builder.put(generation, Collections.unmodifiableSet(new LinkedHashSet(hostnames))));
        this.generationsForRestarts = Collections.unmodifiableMap(builder);
    }

    public Map<Long, Set<String>> generationsForRestarts() {
        return this.generationsForRestarts;
    }

    public boolean isEmpty() {
        return this.generationsForRestarts.isEmpty();
    }

    public PendingRestarts withRestarts(long atGeneration, final Collection<String> hostnames) {
        LinkedHashMap<Long, Set<String>> newRestarts = new LinkedHashMap<Long, Set<String>>(this.generationsForRestarts);
        newRestarts.put(atGeneration, (Set<String>)new LinkedHashSet<String>((Collection)newRestarts.getOrDefault(atGeneration, Set.of())){
            {
                super(arg0);
                this.addAll(hostnames);
            }
        });
        return new PendingRestarts(newRestarts);
    }

    public PendingRestarts withoutPreviousGenerations(long generation) {
        LinkedHashMap<Long, Set<String>> newRestarts = new LinkedHashMap<Long, Set<String>>(this.generationsForRestarts);
        newRestarts.keySet().removeIf(g -> g <= generation);
        return new PendingRestarts(newRestarts);
    }

    public Set<String> hostnames() {
        return this.restartsReadyAt(Long.MAX_VALUE);
    }

    public Set<String> restartsReadyAt(long generation) {
        LinkedHashSet<String> ready = new LinkedHashSet<String>();
        this.generationsForRestarts.forEach((g, hosts) -> {
            if (g <= generation) {
                ready.addAll((Collection<String>)hosts);
            }
        });
        return ready;
    }
}

