/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.curator.Curator;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class ZKApplication {
    public static final String DEFCONFIGS_ZK_SUBPATH = "/defconfigs";
    public static final String USER_DEFCONFIGS_ZK_SUBPATH = "/userdefconfigs";
    public static final String META_ZK_PATH = "/meta";
    public static final String USERAPP_ZK_SUBPATH = "/userapp";
    public static final String SESSIONSTATE_ZK_SUBPATH = "/sessionState";
    private final Curator curator;
    private final Path appPath;
    private final int maxNodeSize;

    ZKApplication(Curator curator, Path appPath, int maxNodeSize) {
        this.curator = curator;
        this.appPath = appPath;
        this.maxNodeSize = maxNodeSize;
    }

    ZKApplication(Curator curator, Path appPath) {
        this(curator, appPath, 0xA00000);
    }

    List<NamedReader> getAllDataFromDirectory(Path path, String fileNameSuffix, boolean recursive) {
        return this.getAllDataFromDirectory(path, "", fileNameSuffix, recursive);
    }

    private List<NamedReader> getAllDataFromDirectory(Path path, String namePrefix, String fileNameSuffix, boolean recursive) {
        ArrayList<NamedReader> result = new ArrayList<NamedReader>();
        List<String> children = this.getChildren(path);
        try {
            for (String child : children) {
                if (fileNameSuffix == null || child.endsWith(fileNameSuffix)) {
                    result.add(new NamedReader(namePrefix + child, ZKApplication.reader(this.getData(path.append(child)))));
                }
                if (!recursive) continue;
                result.addAll(this.getAllDataFromDirectory(path.append(child), namePrefix + child + "/", fileNameSuffix, recursive));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve all data from '" + path + "' in zookeeper", e);
        }
    }

    Reader getDataReader(Path path) {
        return ZKApplication.reader(this.getData(path));
    }

    NamedReader getNamedReader(String name, Path path) {
        return new NamedReader(name, ZKApplication.reader(this.getData(path)));
    }

    public String getData(Path path) {
        return Utf8.toString((byte[])this.getBytesInternal(this.getFullPath(path)));
    }

    private byte[] getBytesInternal(Path path) {
        return (byte[])this.curator.getData(path).orElseThrow(() -> new IllegalArgumentException("Could not get data from '" + path + "' in zookeeper"));
    }

    public byte[] getBytes(Path path) {
        return this.getBytesInternal(this.getFullPath(path));
    }

    public long getSize(Path path) {
        return this.curator.getStat(path).map(stat -> stat.getDataLength()).orElseThrow(() -> new IllegalArgumentException("Could not get size from '" + path + "' in zookeeper"));
    }

    void putData(Path path, String data) {
        this.putData(path, Utf8.toBytes((String)data));
    }

    void putData(Path path, byte[] bytes) {
        this.ensureDataIsNotTooLarge(bytes, path);
        try {
            this.curator.set(this.getFullPath(path), bytes);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not put data to node '" + this.getFullPath(path) + "' in zookeeper", e);
        }
    }

    private void ensureDataIsNotTooLarge(byte[] toPut, Path path) {
        if (toPut.length >= this.maxNodeSize) {
            throw new IllegalArgumentException("Error: too much zookeeper data in node: [" + toPut.length + " bytes] (path " + path + ")");
        }
    }

    public boolean exists(Path path) {
        return this.curator.exists(this.getFullPath(path));
    }

    private Path getFullPath(Path path) {
        Path fullPath = this.appPath;
        if (path != null) {
            fullPath = this.appPath.append(path);
        }
        return fullPath;
    }

    void deleteRecurse(Path path) {
        this.curator.delete(this.getFullPath(path));
    }

    public List<String> getChildren(Path path) {
        return this.curator.getChildren(this.getFullPath(path));
    }

    private static Reader reader(String string) {
        return new StringReader(string);
    }

    public void create(Path path) {
        try {
            this.curator.create(this.getFullPath(path));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

