/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final File downloadDirectory;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
    private final FileDownloader fileDownloader;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval) {
        super(applicationRepository, curator, applicationRepository.flagSource(), applicationRepository.clock(), interval, false);
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(applicationRepository.configserverConfig().fileReferencesDir()));
        this.fileDownloader = ApplicationPackageMaintainer.createFileDownloader(applicationRepository, this.downloadDirectory, this.supervisor);
    }

    protected double maintain() {
        int attempts = 0;
        int[] failures = new int[1];
        ArrayList<Runnable> futureDownloads = new ArrayList<Runnable>();
        for (Session session : this.preparedAndActivatedSessions()) {
            Optional<FileReference> appFileReference;
            if (this.shuttingDown()) {
                return this.asSuccessFactorDeviation(attempts, failures[0]);
            }
            ApplicationId applicationId = session.getOptionalApplicationId().orElse(null);
            if (applicationId == null || !(appFileReference = session.getApplicationPackageReference()).isPresent()) continue;
            long sessionId = session.getSessionId();
            FileReference fileReference = appFileReference.get();
            ++attempts;
            if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, fileReference)) {
                Future<Optional<File>> futureDownload = this.startDownload(fileReference, sessionId, applicationId);
                futureDownloads.add(() -> {
                    try {
                        if (((Optional)futureDownload.get()).isPresent()) {
                            this.createLocalSessionIfMissing(applicationId, sessionId);
                            return;
                        }
                    }
                    catch (Exception e) {
                        log.warning("Exception when downloading application package (" + fileReference + ") for " + applicationId + " (session " + sessionId + "): " + e.getMessage());
                    }
                    failures[0] = failures[0] + 1;
                    log.info("Downloading application package (" + fileReference + ") for " + applicationId + " (session " + sessionId + ") unsuccessful. Can be ignored unless it happens many times over a long period of time, retries is expected");
                });
                continue;
            }
            this.createLocalSessionIfMissing(applicationId, sessionId);
        }
        futureDownloads.forEach(Runnable::run);
        return this.asSuccessFactorDeviation(attempts, failures[0]);
    }

    private Future<Optional<File>> startDownload(FileReference fileReference, long sessionId, ApplicationId applicationId) {
        log.fine(() -> "Downloading application package with file reference " + fileReference + " for " + applicationId + " (session " + sessionId + ")");
        return this.fileDownloader.getFutureFileOrTimeout(new FileReferenceDownload(fileReference, ((Object)((Object)this)).getClass().getSimpleName(), false));
    }

    private Collection<RemoteSession> preparedAndActivatedSessions() {
        TenantRepository tenantRepository = this.applicationRepository.tenantRepository();
        return tenantRepository.getAllTenantNames().stream().map(tenantRepository::getTenant).map(t -> t.getSessionRepository().getRemoteSessions()).flatMap(Collection::stream).filter(s -> s.getStatus() == Session.Status.PREPARE || s.getStatus() == Session.Status.ACTIVATE).toList();
    }

    private static FileDownloader createFileDownloader(ApplicationRepository applicationRepository, File downloadDirectory, Supervisor supervisor) {
        List<String> otherConfigServersInCluster = FileDistributionUtil.getOtherConfigServersInCluster(applicationRepository.configserverConfig());
        ConfigSourceSet configSourceSet = new ConfigSourceSet(otherConfigServersInCluster);
        FileDistributionConnectionPool connectionPool = new FileDistributionConnectionPool(configSourceSet, supervisor);
        return new FileDownloader((ConnectionPool)connectionPool, supervisor, downloadDirectory, Duration.ofSeconds(60L));
    }

    public void awaitShutdown() {
        this.supervisor.transport().shutdown().join();
        this.fileDownloader.close();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }
}

