/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.Flags;
import java.time.Duration;
import java.util.logging.Level;

public class SessionsMaintainer
extends ConfigServerMaintainer {
    private final BooleanFlag deleteRemoteAndLocalAtTheSameTime;

    SessionsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval) {
        super(applicationRepository, curator, applicationRepository.flagSource(), applicationRepository.clock(), interval, true, true);
        this.deleteRemoteAndLocalAtTheSameTime = (BooleanFlag)Flags.DELETE_EXPIRED_CONFIG_SESSIONS_NEW_PROCEDURE.bindTo(applicationRepository.flagSource());
    }

    protected double maintain() {
        return this.maintain(() -> {});
    }

    double maintain(Runnable runnable) {
        if (this.deleteRemoteAndLocalAtTheSameTime.value()) {
            this.applicationRepository.deleteExpiredSessions();
        } else {
            this.applicationRepository.deleteExpiredLocalSessions();
            runnable.run();
            int deleted = this.applicationRepository.deleteExpiredRemoteSessions();
            this.log.log(Level.FINE, () -> "Deleted " + deleted + " expired remote sessions");
        }
        return 1.0;
    }
}

