/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.concurrent.UncheckedTimeoutException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class TimeoutBudget {
    private final Clock clock;
    private final Instant startTime;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private final Instant endTime;

    public TimeoutBudget(Clock clock, Duration duration) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.endTime = this.startTime.plus(duration);
    }

    public Duration timeout() {
        return Duration.between(this.startTime, this.endTime);
    }

    public Duration timeLeft() {
        Instant now = this.clock.instant();
        Duration duration = Duration.between(now, this.endTime);
        return duration.isNegative() ? Duration.ZERO : duration;
    }

    public boolean hasTimeLeft() {
        return this.clock.instant().isBefore(this.endTime);
    }

    public boolean hasTimeLeft(String step) {
        Instant now = this.clock.instant();
        this.measurements.add(new Measurement(now, step));
        return now.isBefore(this.endTime);
    }

    public String timesUsed() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Instant prev = this.startTime;
        for (Measurement m : this.measurements) {
            if (!m.label().isEmpty()) {
                buf.append(m.label()).append(": ");
            }
            buf.append(Duration.between(prev, m.timestamp()).toMillis()).append(" ms").append(", ");
            prev = m.timestamp();
        }
        Instant now = this.clock.instant();
        buf.append("total: ");
        buf.append(Duration.between(this.startTime, now).toMillis());
        buf.append(" ms]");
        return buf.toString();
    }

    public void assertNotTimedOut(Supplier<String> exceptionMessage) {
        if (this.hasTimeLeft()) {
            return;
        }
        throw new UncheckedTimeoutException(exceptionMessage.get());
    }

    private static class Measurement {
        private final Instant timestamp;
        private final String label;

        Measurement(Instant timestamp, String label) {
            this.timestamp = timestamp;
            this.label = label;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public String label() {
            return this.label;
        }
    }
}

