/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.http.client.utils.URIBuilder;

public class TesterClient {
    private final CloseableHttpClient httpClient = VespaHttpClientBuilder.custom().buildClient();
    private static final Logger logger = Logger.getLogger(TesterClient.class.getName());

    public HttpResponse getStatus(String testerHostname, int port) {
        URI testerUri = this.createURI(testerHostname, port, "/tester/v1/status");
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get tester status");
    }

    public HttpResponse getLog(String testerHostname, int port, Long after) {
        URI testerUri;
        try {
            testerUri = this.createBuilder(testerHostname, port, "/tester/v1/log").addParameter("after", String.valueOf(after)).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get tester logs");
    }

    public HttpResponse startTests(String testerHostname, int port, String suite, byte[] config) {
        URI testerUri = this.createURI(testerHostname, port, "/tester/v1/run/" + suite);
        HttpPost request = new HttpPost(testerUri);
        request.setEntity((HttpEntity)new ByteArrayEntity(config, ContentType.DEFAULT_BINARY));
        return this.execute((HttpUriRequest)request, "Failed to start tests");
    }

    public HttpResponse isTesterReady(String testerHostname, int port) {
        URI testerUri = this.createURI(testerHostname, port, "/status.html");
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "/status.html did not return 200 OK");
    }

    public HttpResponse getReport(String testerHostname, int port) {
        URI testerUri = this.createURI(testerHostname, port, "/tester/v1/report");
        return this.execute((HttpUriRequest)new HttpGet(testerUri), "Failed to get test report");
    }

    private HttpResponse execute(HttpUriRequest request, String messageIfRequestFails) {
        logger.log(Level.FINE, () -> "Sending request to tester container " + request.getRequestUri());
        try {
            return new ProxyResponse(this.httpClient.execute((ClassicHttpRequest)request));
        }
        catch (IOException e) {
            logger.warning(messageIfRequestFails + ": " + Exceptions.toMessageString((Throwable)e));
            return HttpErrorResponse.internalServerError(Exceptions.toMessageString((Throwable)e));
        }
    }

    private URIBuilder createBuilder(String testerHostname, int port, String path) {
        return new URIBuilder().setScheme("https").setHost(testerHostname).setPort(port).setPath(path);
    }

    private URI createURI(String testerHostname, int port, String path) {
        try {
            return this.createBuilder(testerHostname, port, path).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

