/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.config.model.api.EndpointCertificateSecretStore;
import com.yahoo.container.jdisc.secretstore.SecretNotFoundException;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import java.util.Optional;
import javax.inject.Inject;

public class DefaultEndpointCertificateSecretStore
extends EndpointCertificateSecretStore {
    private final SecretStore secretStore;

    @Inject
    public DefaultEndpointCertificateSecretStore(SecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public Optional<String> getPrivateKey(EndpointCertificateMetadata metadata) {
        return this.getValue(metadata.keyName(), metadata.version());
    }

    public Optional<String> getCertificate(EndpointCertificateMetadata metadata) {
        return this.getValue(metadata.certName(), metadata.version());
    }

    private Optional<String> getValue(String key, int version) {
        try {
            return Optional.ofNullable(this.secretStore.getSecret(key, version));
        }
        catch (SecretNotFoundException e) {
            return Optional.empty();
        }
    }

    public boolean supports(EndpointCertificateMetadata.Provider provider) {
        return provider == EndpointCertificateMetadata.Provider.digicert || provider == EndpointCertificateMetadata.Provider.globalsign;
    }
}

