/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.path.Path;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.tenant.ApplicationRolesSerializer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.Optional;

public class ApplicationRolesStore {
    private final Path path;
    private final Curator curator;

    public ApplicationRolesStore(Curator curator, Path tenantPath) {
        this.curator = curator;
        this.path = tenantPath.append("applicationRoles/");
    }

    public Optional<ApplicationRoles> readApplicationRoles(ApplicationId application) {
        try {
            Optional data = this.curator.getData(this.applicationRolesPath(application));
            if (data.isEmpty() || ((byte[])data.get()).length == 0) {
                return Optional.empty();
            }
            Slime slime = SlimeUtils.jsonToSlime((byte[])((byte[])data.get()));
            ApplicationRoles applicationRoles = ApplicationRolesSerializer.fromSlime((Inspector)slime.get());
            return Optional.of(applicationRoles);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading application roles of " + application, e);
        }
    }

    public void writeApplicationRoles(ApplicationId application, ApplicationRoles applicationRoles) {
        try {
            Slime slime = new Slime();
            ApplicationRolesSerializer.toSlime(applicationRoles, slime.setObject());
            this.curator.set(this.applicationRolesPath(application), SlimeUtils.toJsonBytes((Slime)slime));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write application roles of " + application, e);
        }
    }

    public CuratorTransaction delete(ApplicationId application) {
        if (!this.curator.exists(this.applicationRolesPath(application))) {
            return CuratorTransaction.empty((Curator)this.curator);
        }
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.applicationRolesPath(application).getAbsolute()), (Curator)this.curator);
    }

    private Path applicationRolesPath(ApplicationId application) {
        return this.path.append(application.serializedForm());
    }
}

