/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.version;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.annotation.Inject;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VersionState {
    private static final Logger log = Logger.getLogger(VersionState.class.getName());
    private static final int allowedMinorVersionInterval = 30;
    private static final Version latestVersionOnPreviousMajor = Version.fromString((String)"7.594.36");
    static final Path versionPath = Path.fromString((String)"/config/v2/vespa_version");
    private final File versionFile;
    private final Curator curator;
    private final Version currentVersion;
    private final boolean skipUpgradeCheck;

    @Inject
    public VersionState(ConfigserverConfig config, Curator curator) {
        this(new File(Defaults.getDefaults().underVespaHome(config.configServerDBDir()), "vespa_version"), curator, Boolean.parseBoolean(Optional.ofNullable(System.getenv("VESPA_SKIP_UPGRADE_CHECK")).orElse("false")));
    }

    public VersionState(File versionFile, Curator curator, boolean skipUpgradeCheck) {
        this(versionFile, curator, new Version(8, 330, 52), skipUpgradeCheck);
    }

    public VersionState(File versionFile, Curator curator, Version currentVersion, boolean skipUpgradeCheck) {
        this.versionFile = versionFile;
        this.curator = curator;
        this.currentVersion = currentVersion;
        this.skipUpgradeCheck = skipUpgradeCheck;
    }

    public boolean isUpgraded() {
        Version storedVersion = this.storedVersion();
        if (storedVersion.equals((Object)Version.emptyVersion)) {
            return true;
        }
        if (this.currentVersion().compareTo(storedVersion) > 0) {
            this.verifyVersionIntervalForUpgrade(storedVersion);
            return true;
        }
        return false;
    }

    public void storeCurrentVersion() {
        this.storeVersion(this.currentVersion().toFullString());
    }

    public void storeVersion(String vespaVersion) {
        this.curator.set(versionPath, Utf8.toBytes((String)vespaVersion));
        try (FileWriter writer = new FileWriter(this.versionFile);){
            writer.write(vespaVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Version storedVersion() {
        Version version;
        Optional version2 = this.curator.getData(versionPath);
        if (version2.isPresent()) {
            try {
                return Version.fromString((String)Utf8.toString((byte[])((byte[])version2.get())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileReader reader = new FileReader(this.versionFile);
        try {
            version = Version.fromString((String)IOUtils.readAll((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Version.emptyVersion;
            }
        }
        reader.close();
        return version;
    }

    public Version currentVersion() {
        return this.currentVersion;
    }

    File versionFile() {
        return this.versionFile;
    }

    public String toString() {
        return String.format("Current version:%s, stored version:%s", this.currentVersion(), this.storedVersion());
    }

    private void verifyVersionIntervalForUpgrade(Version storedVersion) {
        int storedVersionMajor = storedVersion.getMajor();
        int storedVersionMinor = storedVersion.getMinor();
        int currentVersionMajor = this.currentVersion.getMajor();
        int currentVersionMinor = this.currentVersion.getMinor();
        boolean sameMajor = storedVersionMajor == currentVersionMajor;
        boolean differentMajor = !sameMajor;
        String message = "Cannot upgrade from " + storedVersion + " to " + this.currentVersion();
        if (storedVersionMajor < latestVersionOnPreviousMajor.getMajor()) {
            this.logOrThrow(message + " (upgrade across 2 major versions not supported). Please upgrade to " + latestVersionOnPreviousMajor.toFullString() + " first. Setting VESPA_SKIP_UPGRADE_CHECK=true will skip this check at your own risk, see https://vespa.ai/releases.html#versions");
        } else if (sameMajor && currentVersionMinor - storedVersionMinor > 30) {
            this.logOrThrow(message + ". Please upgrade to an older version first, the interval between the two versions is too large (> 30 releases). Setting VESPA_SKIP_UPGRADE_CHECK=true will skip this check at your own risk, see https://vespa.ai/releases.html#versions");
        } else if (differentMajor && storedVersionMinor < latestVersionOnPreviousMajor.getMinor()) {
            this.logOrThrow(message + " (new major version). Please upgrade to " + latestVersionOnPreviousMajor.toFullString() + " first. Setting VESPA_SKIP_UPGRADE_CHECK=true will skip this check at your own risk, see https://vespa.ai/releases.html#versions");
        } else if (differentMajor && currentVersionMinor > 30) {
            this.logOrThrow(message + ". Please upgrade to an older version first, the interval between the two versions is too large (> 30 releases). Setting VESPA_SKIP_UPGRADE_CHECK=true will skip this check at your own risk, see https://vespa.ai/releases.html#versions");
        }
    }

    private void logOrThrow(String message) {
        if (!this.skipUpgradeCheck) {
            throw new RuntimeException(message);
        }
        log.log(Level.WARNING, message);
    }
}

