/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.provision.InfraDeployer;
import java.util.Optional;

public class InfraDeployerProvider {
    private final Optional<InfraDeployer> infraDeployer;

    public InfraDeployerProvider(ComponentRegistry<InfraDeployer> infraDeployerRegistry, ConfigserverConfig configserverConfig) {
        this.infraDeployer = infraDeployerRegistry.allComponents().isEmpty() || !configserverConfig.hostedVespa() ? Optional.empty() : Optional.of((InfraDeployer)infraDeployerRegistry.allComponents().get(0));
    }

    private InfraDeployerProvider(ComponentRegistry<InfraDeployer> componentRegistry) {
        this(componentRegistry, new ConfigserverConfig(new ConfigserverConfig.Builder()));
    }

    public Optional<InfraDeployer> getInfraDeployer() {
        return this.infraDeployer;
    }

    public static InfraDeployerProvider empty() {
        return new InfraDeployerProvider((ComponentRegistry<InfraDeployer>)new ComponentRegistry());
    }

    public static InfraDeployerProvider withInfraDeployer(InfraDeployer infraDeployer) {
        ComponentRegistry registry = new ComponentRegistry();
        registry.register(ComponentId.createAnonymousComponentId((String)"foobar"), (Object)infraDeployer);
        return new InfraDeployerProvider((ComponentRegistry<InfraDeployer>)registry, new ConfigserverConfig(new ConfigserverConfig.Builder().hostedVespa(true)));
    }

    public static InfraDeployerProvider from(Optional<InfraDeployer> infraDeployer) {
        return infraDeployer.map(InfraDeployerProvider::withInfraDeployer).orElseGet(InfraDeployerProvider::empty);
    }
}

